/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.scheduler.ThreadPool;
import org.neo4j.scheduler.JobScheduler;

final class ThreadPoolManager {
    private final ConcurrentHashMap<JobScheduler.Group, ThreadPool> pools = new ConcurrentHashMap();
    private final Function<JobScheduler.Group, ThreadPool> poolBuilder = group -> new ThreadPool((JobScheduler.Group)group, topLevelGroup);

    ThreadPoolManager(ThreadGroup topLevelGroup) {
    }

    ThreadPool getThreadPool(JobScheduler.Group group) {
        return this.pools.computeIfAbsent(group, this.poolBuilder);
    }

    JobScheduler.JobHandle submit(JobScheduler.Group group, Runnable job) {
        ThreadPool threadPool = this.getThreadPool(group);
        return threadPool.submit(job);
    }

    public InterruptedException shutDownAll() {
        this.pools.forEach((group, pool) -> pool.cancelAllJobs());
        this.pools.forEach((group, pool) -> pool.shutDown());
        return this.pools.values().stream().map(ThreadPool::getShutdownException).reduce(null, Exceptions::chain);
    }
}

