/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import java.time.Duration;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.neo4j.bolt.runtime.ExecutorFactory;
import org.neo4j.logging.Log;

public class CachedThreadPoolExecutorFactory
implements ExecutorFactory {
    public static final int UNBOUNDED_QUEUE = -1;
    public static final int SYNCHRONOUS_QUEUE = 0;
    private final Log log;
    private final RejectedExecutionHandler rejectionHandler;

    public CachedThreadPoolExecutorFactory(Log log) {
        this(log, new ThreadPoolExecutor.AbortPolicy());
    }

    public CachedThreadPoolExecutorFactory(Log log, RejectedExecutionHandler rejectionHandler) {
        this.log = log;
        this.rejectionHandler = rejectionHandler;
    }

    @Override
    public ExecutorService create(int corePoolSize, int maxPoolSize, Duration keepAlive, int queueSize, boolean startCoreThreads, ThreadFactory threadFactory) {
        ThreadPool result = new ThreadPool(corePoolSize, maxPoolSize, keepAlive, CachedThreadPoolExecutorFactory.createTaskQueue(queueSize), threadFactory, this.rejectionHandler);
        if (startCoreThreads) {
            result.prestartAllCoreThreads();
        }
        return result;
    }

    private static BlockingQueue<Runnable> createTaskQueue(int queueSize) {
        if (queueSize == -1) {
            return new LinkedBlockingQueue<Runnable>();
        }
        if (queueSize == 0) {
            return new SynchronousQueue<Runnable>();
        }
        if (queueSize > 0) {
            return new ArrayBlockingQueue<Runnable>(queueSize);
        }
        throw new IllegalArgumentException(String.format("Unsupported queue size %d for thread pool creation.", queueSize));
    }

    private class ThreadPool
    extends ThreadPoolExecutor {
        private ThreadPool(int corePoolSize, int maxPoolSize, Duration keepAlive, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectionHandler) {
            super(corePoolSize, maxPoolSize, keepAlive.toMillis(), TimeUnit.MILLISECONDS, workQueue, threadFactory, rejectionHandler);
        }
    }
}

