/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.prettyprint;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.neo4j.shell.prettyprint.LinePrinter;
import org.neo4j.shell.prettyprint.OutputFormatter;
import org.neo4j.shell.state.BoltResult;

public class SimpleOutputFormatter
implements OutputFormatter {
    @Override
    public int formatAndCount(@Nonnull BoltResult result2, @Nonnull LinePrinter output) {
        Iterator<Record> records = result2.iterate();
        int numberOfRows = 0;
        if (records.hasNext()) {
            Record firstRow = records.next();
            output.printOut(String.join((CharSequence)", ", firstRow.keys()));
            output.printOut(this.formatRecord(firstRow));
            ++numberOfRows;
            while (records.hasNext()) {
                output.printOut(this.formatRecord(records.next()));
                ++numberOfRows;
            }
        }
        return numberOfRows;
    }

    @Nonnull
    private String formatRecord(@Nonnull Record record) {
        return record.values().stream().map(this::formatValue).collect(Collectors.joining(", "));
    }

    @Override
    @Nonnull
    public String formatInfo(@Nonnull ResultSummary summary) {
        if (!summary.hasPlan()) {
            return "";
        }
        Map<String, Value> info2 = OutputFormatter.info(summary);
        return info2.entrySet().stream().map(e -> String.format("%s: %s", e.getKey(), e.getValue())).collect(Collectors.joining(NEWLINE));
    }

    @Override
    public Set<OutputFormatter.Capabilities> capabilities() {
        return EnumSet.of(OutputFormatter.Capabilities.INFO, OutputFormatter.Capabilities.STATISTICS, OutputFormatter.Capabilities.RESULT);
    }
}

