/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.kernel.recovery.RecoveryStartInformation;

public class RecoveryStartInformationProvider
implements ThrowingSupplier<RecoveryStartInformation, IOException> {
    public static final Monitor NO_MONITOR = new Monitor(){};
    private final LogTailScanner logTailScanner;
    private final Monitor monitor;

    public RecoveryStartInformationProvider(LogTailScanner logTailScanner, Monitor monitor) {
        this.logTailScanner = logTailScanner;
        this.monitor = monitor;
    }

    @Override
    public RecoveryStartInformation get() {
        LogTailScanner.LogTailInformation logTailInformation = this.logTailScanner.getTailInformation();
        CheckPoint lastCheckPoint = logTailInformation.lastCheckPoint;
        long txIdAfterLastCheckPoint = logTailInformation.firstTxIdAfterLastCheckPoint;
        if (!logTailInformation.commitsAfterLastCheckpoint()) {
            this.monitor.noCommitsAfterLastCheckPoint(lastCheckPoint != null ? lastCheckPoint.getLogPosition() : null);
            return this.createRecoveryInformation(LogPosition.UNSPECIFIED, txIdAfterLastCheckPoint);
        }
        if (lastCheckPoint != null) {
            this.monitor.commitsAfterLastCheckPoint(lastCheckPoint.getLogPosition(), txIdAfterLastCheckPoint);
            return this.createRecoveryInformation(lastCheckPoint.getLogPosition(), txIdAfterLastCheckPoint);
        }
        if (logTailInformation.oldestLogVersionFound != 0L) {
            long fromLogVersion = Math.max(0L, logTailInformation.oldestLogVersionFound);
            throw new UnderlyingStorageException("No check point found in any log file from version " + fromLogVersion + " to " + logTailInformation.currentLogVersion);
        }
        this.monitor.noCheckPointFound();
        return this.createRecoveryInformation(LogPosition.start(0L), txIdAfterLastCheckPoint);
    }

    private RecoveryStartInformation createRecoveryInformation(LogPosition logPosition, long firstTxId) {
        return new RecoveryStartInformation(logPosition, firstTxId);
    }

    public static interface Monitor {
        default public void noCommitsAfterLastCheckPoint(LogPosition logPosition) {
        }

        default public void commitsAfterLastCheckPoint(LogPosition logPosition, long firstTxIdAfterLastCheckPoint) {
        }

        default public void noCheckPointFound() {
        }
    }
}

