/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.TemporalIndexAccessor;
import org.neo4j.kernel.impl.index.schema.TemporalIndexCache;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.values.storable.ValueGroup;

public class TemporalIndexUpdater
extends TemporalIndexCache<NativeIndexUpdater<?, NativeIndexValue>>
implements IndexUpdater {
    TemporalIndexUpdater(TemporalIndexAccessor accessor, IndexUpdateMode mode) {
        super(new PartFactory(accessor, mode));
    }

    @Override
    public void process(IndexEntryUpdate<?> update2) throws IndexEntryConflictException {
        IndexUpdater to2 = (IndexUpdater)this.select(update2.values()[0].valueGroup());
        switch (update2.updateMode()) {
            case ADDED: 
            case REMOVED: {
                to2.process(update2);
                break;
            }
            case CHANGED: {
                IndexUpdater from2 = (IndexUpdater)this.select(update2.beforeValues()[0].valueGroup());
                if (from2 == to2) {
                    from2.process(update2);
                    break;
                }
                from2.process(IndexEntryUpdate.remove(update2.getEntityId(), update2.indexKey(), update2.beforeValues()));
                to2.process(IndexEntryUpdate.add(update2.getEntityId(), update2.indexKey(), update2.values()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update mode");
            }
        }
    }

    @Override
    public void close() {
        FusionIndexBase.forAll(NativeIndexUpdater::close, this);
    }

    static class PartFactory
    implements TemporalIndexCache.Factory<NativeIndexUpdater<?, NativeIndexValue>> {
        private final TemporalIndexAccessor accessor;
        private final IndexUpdateMode mode;

        PartFactory(TemporalIndexAccessor accessor, IndexUpdateMode mode) {
            this.accessor = accessor;
            this.mode = mode;
        }

        @Override
        public NativeIndexUpdater<?, NativeIndexValue> newDate() {
            return ((TemporalIndexAccessor.PartAccessor)this.accessor.select(ValueGroup.DATE)).newUpdater(this.mode);
        }

        @Override
        public NativeIndexUpdater<?, NativeIndexValue> newLocalDateTime() {
            return ((TemporalIndexAccessor.PartAccessor)this.accessor.select(ValueGroup.LOCAL_DATE_TIME)).newUpdater(this.mode);
        }

        @Override
        public NativeIndexUpdater<?, NativeIndexValue> newZonedDateTime() {
            return ((TemporalIndexAccessor.PartAccessor)this.accessor.select(ValueGroup.ZONED_DATE_TIME)).newUpdater(this.mode);
        }

        @Override
        public NativeIndexUpdater<?, NativeIndexValue> newLocalTime() {
            return ((TemporalIndexAccessor.PartAccessor)this.accessor.select(ValueGroup.LOCAL_TIME)).newUpdater(this.mode);
        }

        @Override
        public NativeIndexUpdater<?, NativeIndexValue> newZonedTime() {
            return ((TemporalIndexAccessor.PartAccessor)this.accessor.select(ValueGroup.ZONED_TIME)).newUpdater(this.mode);
        }

        @Override
        public NativeIndexUpdater<?, NativeIndexValue> newDuration() {
            return ((TemporalIndexAccessor.PartAccessor)this.accessor.select(ValueGroup.DURATION)).newUpdater(this.mode);
        }
    }
}

