/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.SettingValidator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.logging.Log;

public class IndividualSettingsValidator
implements ConfigurationValidator {
    private static final List<String> reservedPrefixes = Arrays.asList("dbms.", "metrics.", "ha.", "causal_clustering.", "browser.", "tools.", "unsupported.");
    private final Collection<SettingValidator> settingValidators;
    private final boolean warnOnUnknownSettings;

    IndividualSettingsValidator(Collection<SettingValidator> settingValidators, boolean warnOnUnknownSettings) {
        this.settingValidators = settingValidators;
        this.warnOnUnknownSettings = warnOnUnknownSettings;
    }

    @Override
    public Map<String, String> validate(@Nonnull Config config, @Nonnull Log log) throws InvalidSettingException {
        Map<String, String> rawConfig = config.getRaw();
        Map validConfig = MapUtil.stringMap((String[])new String[0]);
        for (SettingValidator validator : this.settingValidators) {
            validConfig.putAll(validator.validate(rawConfig, arg_0 -> ((Log)log).warn(arg_0)));
        }
        boolean strictValidation = config.get(GraphDatabaseSettings.strict_config_validation);
        rawConfig.forEach((key, value2) -> {
            if (!validConfig.containsKey(key)) {
                if (reservedPrefixes.stream().anyMatch(key::startsWith)) {
                    if (this.warnOnUnknownSettings) {
                        log.warn("Unknown config option: %s", new Object[]{key});
                    }
                    if (strictValidation) {
                        throw new InvalidSettingException(String.format("Unknown config option '%s'. To resolve either remove it from your configuration or set '%s' to false.", key, GraphDatabaseSettings.strict_config_validation.name()));
                    }
                    validConfig.put(key, value2);
                } else {
                    validConfig.put(key, value2);
                }
            }
        });
        return Collections.emptyMap();
    }
}

