/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.diagnostics.jmx;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Optional;
import org.neo4j.dbms.diagnostics.jmx.JmxDump;
import org.neo4j.dbms.diagnostics.jmx.LocalVirtualMachine;
import org.neo4j.io.fs.FileSystemAbstraction;

public class JMXDumper {
    private final Path homeDir;
    private final FileSystemAbstraction fs;
    private final PrintStream err;
    private final boolean verbose;
    private PrintStream out;

    public JMXDumper(Path homeDir, FileSystemAbstraction fs, PrintStream out, PrintStream err, boolean verbose) {
        this.homeDir = homeDir;
        this.fs = fs;
        this.err = err;
        this.verbose = verbose;
        this.out = out;
    }

    public Optional<JmxDump> getJMXDump() {
        this.out.println("Finding running instance of neo4j");
        Optional<Long> pid = this.getPid();
        if (pid.isPresent()) {
            return this.getJMXDump(pid.get());
        }
        this.out.println("No running instance of ONgDB was found. Online reports will be omitted.");
        this.out.println("If ONgDB is running but not detected, you can supply the process id of the running instance with --pid");
        return Optional.empty();
    }

    public Optional<JmxDump> getJMXDump(long pid) {
        try {
            LocalVirtualMachine vm = LocalVirtualMachine.from(pid);
            this.out.println("Attached to running process with process id " + pid);
            try {
                JmxDump jmxDump = JmxDump.connectTo(vm.getJmxAddress());
                jmxDump.attachSystemProperties(vm.getSystemProperties());
                this.out.println("Connected to JMX endpoint");
                return Optional.of(jmxDump);
            }
            catch (IOException e) {
                this.printError("Unable to communicate with JMX endpoint. Reason: " + e.getMessage(), e);
            }
        }
        catch (NoClassDefFoundError e) {
            this.printError("Unable to attach to process. Reason: JDK is not available, please point environment variable JAVA_HOME to a valid JDK location.", e);
        }
        catch (IOException e) {
            this.printError("Unable to connect to process with process id " + pid + ". Reason: " + e.getMessage(), e);
        }
        return Optional.empty();
    }

    private void printError(String message, Throwable e) {
        this.err.println(message);
        if (this.verbose && e != null) {
            e.printStackTrace(this.err);
        }
    }

    private void printError(String message) {
        this.printError(message, null);
    }

    /*
     * Exception decompiling
     */
    private Optional<Long> getPid() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

