/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.diagnostics.jmx;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.neo4j.dbms.diagnostics.jmx.Reports;
import org.neo4j.diagnostics.DiagnosticsReportSource;
import org.neo4j.diagnostics.DiagnosticsReportSources;
import org.neo4j.diagnostics.DiagnosticsReporterProgress;
import org.neo4j.diagnostics.ProgressAwareInputStream;

public class JmxDump {
    private final MBeanServerConnection mBeanServer;
    private Properties systemProperties;

    private JmxDump(MBeanServerConnection mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public static JmxDump connectTo(String jmxAddress) throws IOException {
        JMXServiceURL url = new JMXServiceURL(jmxAddress);
        JMXConnector connect = JMXConnectorFactory.connect(url);
        return new JmxDump(connect.getMBeanServerConnection());
    }

    public void attachSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public DiagnosticsReportSource threadDump() {
        return DiagnosticsReportSources.newDiagnosticsString((String)"threaddump.txt", () -> {
            String result;
            try {
                result = (String)this.mBeanServer.invoke(new ObjectName("com.sun.management:type=DiagnosticCommand"), "threadPrint", new Object[]{null}, new String[]{String[].class.getName()});
            }
            catch (IOException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException exception) {
                result = this.getMXThreadDump();
            }
            return result;
        });
    }

    private String getMXThreadDump() {
        ThreadMXBean threadMxBean;
        try {
            threadMxBean = ManagementFactory.getPlatformMXBean(this.mBeanServer, ThreadMXBean.class);
        }
        catch (IOException e) {
            return "ERROR: Unable to produce any thread dump";
        }
        ThreadInfo[] threadInfos = threadMxBean.dumpAllThreads(true, true);
        String vmName = this.systemProperties.getProperty("java.vm.name");
        String vmVersion = this.systemProperties.getProperty("java.vm.version");
        String vmInfoString = this.systemProperties.getProperty("java.vm.info");
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Full thread dump %s (%s %s):\n\n", vmName, vmVersion, vmInfoString));
        for (ThreadInfo threadInfo : threadInfos) {
            sb.append(String.format("\"%s\" #%d\n", threadInfo.getThreadName(), threadInfo.getThreadId()));
            sb.append("   java.lang.Thread.State: ").append((Object)threadInfo.getThreadState()).append("\n");
            StackTraceElement[] stackTrace = threadInfo.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                StackTraceElement e = stackTrace[i];
                sb.append("\tat ").append(e.toString());
                if (i == 0 && threadInfo.getLockInfo() != null) {
                    Thread.State ts = threadInfo.getThreadState();
                    switch (ts) {
                        case BLOCKED: {
                            sb.append("\t-  blocked on ").append(threadInfo.getLockInfo()).append('\n');
                            break;
                        }
                        case WAITING: {
                            sb.append("\t-  waiting on ").append(threadInfo.getLockInfo()).append('\n');
                            break;
                        }
                        case TIMED_WAITING: {
                            sb.append("\t-  waiting on ").append(threadInfo.getLockInfo()).append('\n');
                            break;
                        }
                    }
                }
                for (MonitorInfo mi : threadInfo.getLockedMonitors()) {
                    if (mi.getLockedStackDepth() != i) continue;
                    sb.append("\t-  locked ").append(mi).append('\n');
                }
            }
        }
        return sb.toString();
    }

    public DiagnosticsReportSource heapDump() {
        return new DiagnosticsReportSource(){

            public String destinationPath() {
                return "heapdump.hprof";
            }

            public void addToArchive(Path archiveDestination, DiagnosticsReporterProgress progress) throws IOException {
                progress.info("dumping...");
                Path tempFile = Files.createTempFile("ongdb-heapdump", ".hprof", new FileAttribute[0]);
                Files.deleteIfExists(tempFile);
                JmxDump.this.heapDump(tempFile.toAbsolutePath().toString());
                progress.info("archiving...");
                long size = Files.size(tempFile);
                InputStream in = Files.newInputStream(tempFile, new OpenOption[0]);
                try (ProgressAwareInputStream inStream = new ProgressAwareInputStream(in, size, arg_0 -> ((DiagnosticsReporterProgress)progress).percentChanged(arg_0));){
                    Files.copy((InputStream)inStream, archiveDestination, new CopyOption[0]);
                }
                Files.delete(tempFile);
            }

            public long estimatedSize(DiagnosticsReporterProgress progress) throws IOException {
                MemoryMXBean bean = ManagementFactory.getPlatformMXBean(JmxDump.this.mBeanServer, MemoryMXBean.class);
                long totalMemory = bean.getHeapMemoryUsage().getCommitted() + bean.getNonHeapMemoryUsage().getCommitted();
                return (long)((double)totalMemory * 1.2);
            }
        };
    }

    private void heapDump(String destination) throws IOException {
        HotSpotDiagnosticMXBean hotSpotDiagnosticMXBean = ManagementFactory.getPlatformMXBean(this.mBeanServer, HotSpotDiagnosticMXBean.class);
        hotSpotDiagnosticMXBean.dumpHeap(destination, false);
    }

    public DiagnosticsReportSource systemProperties() {
        return new DiagnosticsReportSource(){

            public String destinationPath() {
                return "vm.prop";
            }

            public void addToArchive(Path archiveDestination, DiagnosticsReporterProgress progress) throws IOException {
                try (PrintStream printStream = new PrintStream(Files.newOutputStream(archiveDestination, new OpenOption[0]));){
                    JmxDump.this.systemProperties.list(printStream);
                }
            }

            public long estimatedSize(DiagnosticsReporterProgress progress) {
                return 0L;
            }
        };
    }

    public DiagnosticsReportSource environmentVariables() {
        return this.newReportsBeanSource("env.prop", Reports::getEnvironmentVariables);
    }

    public DiagnosticsReportSource listTransactions() {
        return this.newReportsBeanSource("listTransactions.txt", Reports::listTransactions);
    }

    private DiagnosticsReportSource newReportsBeanSource(String destination, ReportsInvoker reportsInvoker) {
        return DiagnosticsReportSources.newDiagnosticsString((String)destination, () -> {
            try {
                ObjectName name = new ObjectName("org.neo4j:instance=kernel#0,name=Reports");
                Reports reportsBean = JMX.newMBeanProxy(this.mBeanServer, name, Reports.class);
                return reportsInvoker.invoke(reportsBean);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                return "Unable to invoke ReportsBean";
            }
        });
    }

    private static interface ReportsInvoker {
        public String invoke(Reports var1);
    }
}

