/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.internal.locker.GlobalStoreLocker;

public class Util {
    private Util() {
    }

    public static Path canonicalPath(Path path) throws IllegalArgumentException {
        return Util.canonicalPath(path.toFile());
    }

    public static Path canonicalPath(String path) throws IllegalArgumentException {
        return Util.canonicalPath(new File(path));
    }

    public static Path canonicalPath(File file) throws IllegalArgumentException {
        try {
            return Paths.get(file.getCanonicalPath(), new String[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse path: " + file, e);
        }
    }

    public static boolean isSameOrChildFile(File parent, File candidate) {
        Path canonicalCandidate = Util.canonicalPath(candidate);
        Path canonicalParentPath = Util.canonicalPath(parent);
        return canonicalCandidate.startsWith(canonicalParentPath);
    }

    public static boolean isSameOrChildPath(Path parent, Path candidate) {
        Path normalizedCandidate = candidate.normalize();
        Path normalizedParent = parent.normalize();
        return normalizedCandidate.startsWith(normalizedParent);
    }

    public static void checkLock(Path databaseDirectory) throws CommandFailed {
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
             GlobalStoreLocker storeLocker = new GlobalStoreLocker((FileSystemAbstraction)fileSystem, databaseDirectory.toFile());){
            storeLocker.checkLock();
        }
        catch (StoreLockException e) {
            throw new CommandFailed("the database is in use -- stop ONgDB and try again", e);
        }
        catch (IOException e) {
            Util.wrapIOException(e);
        }
    }

    public static void wrapIOException(IOException e) throws CommandFailed {
        throw new CommandFailed(String.format("unable to load database: %s: %s", e.getClass().getSimpleName(), e.getMessage()), e);
    }

    @Nonnull
    public static String ongdbVersion() {
        Properties props = new Properties();
        try {
            Util.loadProperties(props);
            return props.getProperty("ongdbVersion");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void loadProperties(Properties props) throws IOException {
        try (InputStream resource = Util.class.getResourceAsStream("/org/neo4j/commandline/build.properties");){
            props.load(resource);
        }
    }
}

