/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.function.Function;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class ConstraintDefinitionRepresentation
extends MappingRepresentation {
    protected final ConstraintDefinition constraintDefinition;

    public ConstraintDefinitionRepresentation(ConstraintDefinition constraintDefinition) {
        super(RepresentationType.CONSTRAINT_DEFINITION);
        this.constraintDefinition = constraintDefinition;
    }

    protected void serialize(MappingSerializer serializer) {
        switch (this.constraintDefinition.getConstraintType()) {
            case UNIQUENESS: 
            case NODE_PROPERTY_EXISTENCE: {
                serializer.putString("label", this.constraintDefinition.getLabel().name());
                break;
            }
            case RELATIONSHIP_PROPERTY_EXISTENCE: {
                serializer.putString("relationshipType", this.constraintDefinition.getRelationshipType().name());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown constraint type:" + this.constraintDefinition.getConstraintType());
            }
        }
        ConstraintType type = this.constraintDefinition.getConstraintType();
        serializer.putString("type", type.name());
        this.serialize(this.constraintDefinition, serializer);
    }

    protected void serialize(ConstraintDefinition constraintDefinition, MappingSerializer serializer) {
        Function<String, Representation> converter = ValueRepresentation::string;
        Iterable propertyKeyRepresentations = Iterables.map(converter, (Iterable)constraintDefinition.getPropertyKeys());
        serializer.putList("property_keys", new ListRepresentation(RepresentationType.STRING, propertyKeyRepresentations));
    }
}

