/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.ArrayList;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.VirtualValues;

public class NodeProxyWrappingNodeValue
extends NodeValue {
    private final Node node;
    private volatile TextArray labels;
    private volatile MapValue properties;

    NodeProxyWrappingNodeValue(Node node) {
        super(node.getId());
        this.node = node;
    }

    public Node nodeProxy() {
        return this.node;
    }

    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        MapValue p;
        TextArray l;
        try {
            l = this.labels();
            p = this.properties();
        }
        catch (NotFoundException e) {
            l = Values.stringArray((String[])new String[0]);
            p = VirtualValues.EMPTY_MAP;
        }
        if (this.id() < 0L) {
            writer.writeVirtualNodeHack((Object)this.node);
        }
        writer.writeNode(this.node.getId(), l, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextArray labels() {
        TextArray l = this.labels;
        if (l == null) {
            NodeProxyWrappingNodeValue nodeProxyWrappingNodeValue = this;
            synchronized (nodeProxyWrappingNodeValue) {
                l = this.labels;
                if (l == null) {
                    ArrayList<String> ls = new ArrayList<String>();
                    for (Label label : this.node.getLabels()) {
                        ls.add(label.name());
                    }
                    l = this.labels = Values.stringArray((String[])ls.toArray(new String[ls.size()]));
                }
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapValue properties() {
        MapValue m = this.properties;
        if (m == null) {
            NodeProxyWrappingNodeValue nodeProxyWrappingNodeValue = this;
            synchronized (nodeProxyWrappingNodeValue) {
                m = this.properties;
                if (m == null) {
                    m = this.properties = ValueUtils.asMapValue(this.node.getAllProperties());
                }
            }
        }
        return m;
    }
}

