/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import org.neo4j.function.Predicates;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.index.GBPTreeFileUtil;

public class GBPTreePageCacheFileUtil
implements GBPTreeFileUtil {
    private final PageCache pageCache;

    public GBPTreePageCacheFileUtil(PageCache pageCache) {
        this.pageCache = pageCache;
    }

    @Override
    public void deleteFile(File storeFile) throws IOException {
        FileHandle fileHandle = GBPTreePageCacheFileUtil.storeFileHandle(this.pageCache, storeFile);
        fileHandle.delete();
    }

    @Override
    public void deleteFileIfPresent(File storeFile) throws IOException {
        try {
            this.deleteFile(storeFile);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    @Override
    public boolean storeFileExists(File storeFile) {
        try {
            return this.pageCache.getCachedFileSystem().streamFilesRecursive(storeFile).anyMatch(Predicates.alwaysTrue());
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void mkdirs(File dir) throws IOException {
        this.pageCache.getCachedFileSystem().mkdirs(dir);
    }

    private static FileHandle storeFileHandle(PageCache pageCache, File storeFile) throws IOException {
        return (FileHandle)pageCache.getCachedFileSystem().streamFilesRecursive(storeFile).findFirst().orElseThrow(() -> new NoSuchFileException(storeFile.getPath()));
    }
}

