/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import java.time.Clock;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.BoltConnectionLifetimeListener;
import org.neo4j.bolt.runtime.BoltConnectionMetricsMonitor;
import org.neo4j.bolt.runtime.BoltConnectionQueueMonitor;
import org.neo4j.bolt.runtime.DefaultBoltConnection;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.Job;
import org.neo4j.kernel.impl.logging.LogService;

public class MetricsReportingBoltConnection
extends DefaultBoltConnection {
    private final BoltConnectionMetricsMonitor metricsMonitor;
    private final Clock clock;

    MetricsReportingBoltConnection(BoltChannel channel, PackOutput output, BoltStateMachine machine, LogService logService, BoltConnectionLifetimeListener listener, BoltConnectionQueueMonitor queueMonitor, BoltConnectionMetricsMonitor metricsMonitor, Clock clock) {
        this(channel, output, machine, logService, listener, queueMonitor, DEFAULT_MAX_BATCH_SIZE, metricsMonitor, clock);
    }

    MetricsReportingBoltConnection(BoltChannel channel, PackOutput output, BoltStateMachine machine, LogService logService, BoltConnectionLifetimeListener listener, BoltConnectionQueueMonitor queueMonitor, int maxBatchSize, BoltConnectionMetricsMonitor metricsMonitor, Clock clock) {
        super(channel, output, machine, logService, listener, queueMonitor, maxBatchSize);
        this.metricsMonitor = metricsMonitor;
        this.clock = clock;
    }

    @Override
    public void start() {
        super.start();
        this.metricsMonitor.connectionOpened();
    }

    @Override
    public void enqueue(Job job) {
        this.metricsMonitor.messageReceived();
        long queuedAt = this.clock.millis();
        super.enqueue(machine -> {
            long queueTime = this.clock.millis() - queuedAt;
            this.metricsMonitor.messageProcessingStarted(queueTime);
            try {
                job.perform(machine);
                this.metricsMonitor.messageProcessingCompleted(this.clock.millis() - queuedAt - queueTime);
            }
            catch (Throwable t) {
                this.metricsMonitor.messageProcessingFailed();
                throw t;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processNextBatch(int batchCount, boolean exitIfNoJobsAvailable) {
        this.metricsMonitor.connectionActivated();
        try {
            boolean continueProcessing = super.processNextBatch(batchCount, exitIfNoJobsAvailable);
            if (!continueProcessing) {
                this.metricsMonitor.connectionClosed();
            }
            boolean bl = continueProcessing;
            return bl;
        }
        finally {
            this.metricsMonitor.connectionWaiting();
        }
    }
}

