/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.exceptions.Status;

public interface AccessMode {
    public boolean allowsReads();

    public boolean allowsWrites();

    public boolean allowsTokenCreates();

    public boolean allowsSchemaWrites();

    public boolean allowsPropertyReads(int var1);

    public boolean allowsProcedureWith(String[] var1);

    public AuthorizationViolationException onViolation(String var1);

    public String name();

    default public boolean isOverridden() {
        return false;
    }

    public static enum Static implements AccessMode
    {
        NONE(false, false, false, false, false, false),
        CREDENTIALS_EXPIRED(false, false, false, false, false, false){

            @Override
            public AuthorizationViolationException onViolation(String msg) {
                return new AuthorizationViolationException(String.format(msg + "%n%nThe credentials you provided were valid, but must be changed before you can use this instance. If this is the first time you are using Neo4j, this is to ensure you are not using the default credentials in production. If you are not using default credentials, you are getting this message because an administrator requires a password change.%nChanging your password is easy to do via the ONgDB Browser.%nIf you are connecting via a shell or programmatically via a driver, just issue a `CALL dbms.changePassword('new password')` statement in the current session, and then restart your driver with the new password configured.", new Object[0]), (Status)Status.Security.CredentialsExpired);
            }
        }
        ,
        READ(true, false, false, false, false, true),
        WRITE_ONLY(false, true, false, false, false, true),
        WRITE(true, true, false, false, false, true),
        TOKEN_WRITE(true, true, true, false, false, true),
        FULL(true, true, true, true, true, true);

        private final boolean read;
        private final boolean write;
        private final boolean token;
        private final boolean schema;
        private final boolean procedure;
        private final boolean property;

        private Static(boolean read, boolean write, boolean token, boolean schema, boolean procedure, boolean property) {
            this.read = read;
            this.write = write;
            this.token = token;
            this.schema = schema;
            this.procedure = procedure;
            this.property = property;
        }

        @Override
        public boolean allowsReads() {
            return this.read;
        }

        @Override
        public boolean allowsWrites() {
            return this.write;
        }

        @Override
        public boolean allowsTokenCreates() {
            return this.token;
        }

        @Override
        public boolean allowsSchemaWrites() {
            return this.schema;
        }

        @Override
        public boolean allowsPropertyReads(int propertyKey) {
            return this.property;
        }

        @Override
        public boolean allowsProcedureWith(String[] allowed) {
            return this.procedure;
        }

        @Override
        public AuthorizationViolationException onViolation(String msg) {
            return new AuthorizationViolationException(msg);
        }
    }
}

