/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.values.AnyValue;
import org.neo4j.values.StructureBuilder;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.InvalidValuesArgumentException;
import org.neo4j.values.utils.TemporalUtil;
import org.neo4j.values.utils.UnsupportedTemporalUnitException;
import org.neo4j.values.virtual.MapValue;

public final class TimeValue
extends TemporalValue<OffsetTime, TimeValue> {
    public static final TimeValue MIN_VALUE = new TimeValue(OffsetTime.MIN);
    public static final TimeValue MAX_VALUE = new TimeValue(OffsetTime.MAX);
    private final OffsetTime value;
    private final long nanosOfDayUTC;
    private static final String OFFSET_PATTERN = "(?<zone>Z|[+-](?<zoneHour>[0-9]{2})(?::?(?<zoneMinute>[0-9]{2}))?)";
    static final String TIME_PATTERN = "(?:(?:(?<longHour>[0-9]{1,2})(?::(?<longMinute>[0-9]{1,2})(?::(?<longSecond>[0-9]{1,2})(?:\\.(?<longFraction>[0-9]{1,9}))?)?)?)|(?:(?<shortHour>[0-9]{2})(?:(?<shortMinute>[0-9]{2})(?:(?<shortSecond>[0-9]{2})(?:\\.(?<shortFraction>[0-9]{1,9}))?)?)?))(?:(?<zone>Z|[+-](?<zoneHour>[0-9]{2})(?::?(?<zoneMinute>[0-9]{2}))?))?";
    private static final Pattern PATTERN = Pattern.compile("(?:T)?(?:(?:(?<longHour>[0-9]{1,2})(?::(?<longMinute>[0-9]{1,2})(?::(?<longSecond>[0-9]{1,2})(?:\\.(?<longFraction>[0-9]{1,9}))?)?)?)|(?:(?<shortHour>[0-9]{2})(?:(?<shortMinute>[0-9]{2})(?:(?<shortSecond>[0-9]{2})(?:\\.(?<shortFraction>[0-9]{1,9}))?)?)?))(?:(?<zone>Z|[+-](?<zoneHour>[0-9]{2})(?::?(?<zoneMinute>[0-9]{2}))?))?");
    static final Pattern OFFSET = Pattern.compile("(?<zone>Z|[+-](?<zoneHour>[0-9]{2})(?::?(?<zoneMinute>[0-9]{2}))?)");

    public static TimeValue time(OffsetTime time) {
        return new TimeValue(Objects.requireNonNull(time, "OffsetTime"));
    }

    public static TimeValue time(int hour, int minute, int second, int nanosOfSecond, String offset) {
        return TimeValue.time(hour, minute, second, nanosOfSecond, TimeValue.parseOffset(offset));
    }

    public static TimeValue time(int hour, int minute, int second, int nanosOfSecond, ZoneOffset offset) {
        return new TimeValue(OffsetTime.of(TimeValue.assertValidArgument(() -> LocalTime.of(hour, minute, second, nanosOfSecond)), offset));
    }

    public static TimeValue time(long nanosOfDayUTC, ZoneOffset offset) {
        return new TimeValue(TimeValue.timeRaw(nanosOfDayUTC, offset));
    }

    public static OffsetTime timeRaw(long nanosOfDayUTC, ZoneOffset offset) {
        return OffsetTime.ofInstant(TimeValue.assertValidArgument(() -> Instant.ofEpochSecond(0L, nanosOfDayUTC)), offset);
    }

    @Override
    public String getTypeName() {
        return "Time";
    }

    public static TimeValue parse(CharSequence text, Supplier<ZoneId> defaultZone, CSVHeaderInformation fieldsFromHeader) {
        if (fieldsFromHeader != null) {
            if (!(fieldsFromHeader instanceof TemporalValue.TimeCSVHeaderInformation)) {
                throw new IllegalStateException("Wrong header information type: " + fieldsFromHeader);
            }
            defaultZone = ((TemporalValue.TimeCSVHeaderInformation)fieldsFromHeader).zoneSupplier(defaultZone);
        }
        return TimeValue.parse(TimeValue.class, PATTERN, TimeValue::parse, text, defaultZone);
    }

    public static TimeValue parse(CharSequence text, Supplier<ZoneId> defaultZone) {
        return TimeValue.parse(TimeValue.class, PATTERN, TimeValue::parse, text, defaultZone);
    }

    public static TimeValue parse(TextValue text, Supplier<ZoneId> defaultZone) {
        return TimeValue.parse(TimeValue.class, PATTERN, TimeValue::parse, text, defaultZone);
    }

    public static TimeValue now(Clock clock) {
        return new TimeValue(OffsetTime.now(clock));
    }

    public static TimeValue now(Clock clock, String timezone) {
        return TimeValue.now(clock.withZone(DateTimeValue.parseZoneName(timezone)));
    }

    public static TimeValue now(Clock clock, Supplier<ZoneId> defaultZone) {
        return TimeValue.now(clock.withZone(defaultZone.get()));
    }

    public static TimeValue build(MapValue map2, Supplier<ZoneId> defaultZone) {
        return (TimeValue)StructureBuilder.build(TimeValue.builder(defaultZone), map2);
    }

    public static TimeValue select(AnyValue from2, Supplier<ZoneId> defaultZone) {
        return TimeValue.builder(defaultZone).selectTime(from2);
    }

    @Override
    boolean hasTime() {
        return true;
    }

    public static TimeValue truncate(TemporalUnit unit, TemporalValue input2, MapValue fields, Supplier<ZoneId> defaultZone) {
        OffsetTime time = input2.getTimePart(defaultZone);
        OffsetTime truncatedOT = TimeValue.assertValidUnit(() -> time.truncatedTo(unit));
        if (fields.size() == 0) {
            return TimeValue.time(truncatedOT);
        }
        AnyValue timezone = fields.get("timezone");
        if (timezone != Values.NO_VALUE) {
            ZonedDateTime currentDT = TimeValue.assertValidArgument(() -> ZonedDateTime.ofInstant(Instant.now(), TimeValue.timezoneOf(timezone)));
            ZoneOffset currentOffset = currentDT.getOffset();
            truncatedOT = truncatedOT.withOffsetSameLocal(currentOffset);
        }
        return TimeValue.updateFieldMapWithConflictingSubseconds(fields, unit, truncatedOT, (mapValue, offsetTime) -> {
            if (mapValue.size() == 0) {
                return TimeValue.time(offsetTime);
            }
            return TimeValue.build(mapValue.updatedWith("time", TimeValue.time(offsetTime)), defaultZone);
        });
    }

    static OffsetTime defaultTime(ZoneId zoneId) {
        return OffsetTime.of(TemporalValue.TemporalFields.hour.defaultValue, TemporalValue.TemporalFields.minute.defaultValue, TemporalValue.TemporalFields.second.defaultValue, TemporalValue.TemporalFields.nanosecond.defaultValue, TimeValue.assertValidZone(() -> ZoneOffset.of(zoneId.toString())));
    }

    static TimeBuilder<TimeValue> builder(final Supplier<ZoneId> defaultZone) {
        return new TimeBuilder<TimeValue>(defaultZone){

            @Override
            protected boolean supportsTimeZone() {
                return true;
            }

            @Override
            public TimeValue buildInternal() {
                boolean selectingTimeZone;
                OffsetTime result2;
                boolean selectingTime = this.fields.containsKey((Object)TemporalValue.TemporalFields.time);
                if (selectingTime) {
                    AnyValue time = (AnyValue)this.fields.get((Object)TemporalValue.TemporalFields.time);
                    if (!(time instanceof TemporalValue)) {
                        throw new InvalidValuesArgumentException(String.format("Cannot construct time from: %s", time));
                    }
                    TemporalValue t = (TemporalValue)time;
                    result2 = t.getTimePart(defaultZone);
                    selectingTimeZone = t.supportsTimeZone();
                } else {
                    ZoneId timezone = this.timezone();
                    if (!(timezone instanceof ZoneOffset)) {
                        timezone = TemporalValue.assertValidArgument(() -> ZonedDateTime.ofInstant(Instant.now(), this.timezone())).getOffset();
                    }
                    result2 = TimeValue.defaultTime(timezone);
                    selectingTimeZone = false;
                }
                result2 = this.assignAllFields(result2);
                if (this.timezone != null) {
                    ZoneOffset currentOffset = TemporalValue.assertValidArgument(() -> ZonedDateTime.ofInstant(Instant.now(), this.timezone())).getOffset();
                    result2 = selectingTime && selectingTimeZone ? result2.withOffsetSameInstant(currentOffset) : result2.withOffsetSameLocal(currentOffset);
                }
                return TimeValue.time(result2);
            }

            @Override
            protected TimeValue selectTime(AnyValue temporal) {
                if (!(temporal instanceof TemporalValue)) {
                    throw new InvalidValuesArgumentException(String.format("Cannot construct time from: %s", temporal));
                }
                if (temporal instanceof TimeValue && this.timezone == null) {
                    return (TimeValue)temporal;
                }
                TemporalValue v = (TemporalValue)temporal;
                OffsetTime time = v.getTimePart(defaultZone);
                if (this.timezone != null) {
                    ZoneOffset currentOffset = TemporalValue.assertValidArgument(() -> ZonedDateTime.ofInstant(Instant.now(), this.timezone())).getOffset();
                    time = time.withOffsetSameInstant(currentOffset);
                }
                return TimeValue.time(time);
            }
        };
    }

    private TimeValue(OffsetTime value2) {
        this.value = value2;
        this.nanosOfDayUTC = TemporalUtil.getNanosOfDayUTC(this.value);
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        TimeValue other2 = (TimeValue)otherValue;
        int compare = Long.compare(this.nanosOfDayUTC, other2.nanosOfDayUTC);
        if (compare == 0) {
            compare = Integer.compare(this.value.getOffset().getTotalSeconds(), other2.value.getOffset().getTotalSeconds());
        }
        return compare;
    }

    @Override
    OffsetTime temporal() {
        return this.value;
    }

    @Override
    LocalDate getDatePart() {
        throw new UnsupportedTemporalUnitException(String.format("Cannot get the date of: %s", this));
    }

    @Override
    LocalTime getLocalTimePart() {
        return this.value.toLocalTime();
    }

    @Override
    OffsetTime getTimePart(Supplier<ZoneId> defaultZone) {
        return this.value;
    }

    @Override
    ZoneId getZoneId(Supplier<ZoneId> defaultZone) {
        return this.value.getOffset();
    }

    @Override
    ZoneId getZoneId() {
        throw new UnsupportedTemporalTypeException("Cannot get the timezone of" + this);
    }

    @Override
    ZoneOffset getZoneOffset() {
        return this.value.getOffset();
    }

    @Override
    public boolean supportsTimeZone() {
        return true;
    }

    @Override
    public boolean equals(Value other2) {
        return other2 instanceof TimeValue && this.value.equals(((TimeValue)other2).value);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeTime(this.value);
    }

    @Override
    public String prettyPrint() {
        return TimeValue.assertPrintable(() -> this.value.format(DateTimeFormatter.ISO_TIME));
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.ZONED_TIME;
    }

    @Override
    protected int computeHash() {
        return Long.hashCode(this.value.toLocalTime().toNanoOfDay() - (long)this.value.getOffset().getTotalSeconds() * 1000000000L);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapTime(this);
    }

    @Override
    public TimeValue add(DurationValue duration) {
        return this.replacement(TimeValue.assertValidArithmetic(() -> this.value.plusNanos(duration.nanosOfDay())));
    }

    @Override
    public TimeValue sub(DurationValue duration) {
        return this.replacement(TimeValue.assertValidArithmetic(() -> this.value.minusNanos(duration.nanosOfDay())));
    }

    @Override
    TimeValue replacement(OffsetTime time) {
        return time == this.value ? this : new TimeValue(time);
    }

    static ZoneOffset parseOffset(String offset) {
        Matcher matcher = OFFSET.matcher(offset);
        if (matcher.matches()) {
            return TimeValue.parseOffset(matcher);
        }
        throw new InvalidValuesArgumentException("Not a valid offset: " + offset);
    }

    static ZoneOffset parseOffset(Matcher matcher) {
        String zone = matcher.group("zone");
        if (null == zone) {
            return null;
        }
        if ("Z".equalsIgnoreCase(zone)) {
            return ZoneOffset.UTC;
        }
        int factor = zone.charAt(0) == '+' ? 1 : -1;
        int hours = Integer.parseInt(matcher.group("zoneHour"));
        int minutes = LocalTimeValue.optInt(matcher.group("zoneMinute"));
        return TimeValue.assertValidZone(() -> ZoneOffset.ofHoursMinutes(factor * hours, factor * minutes));
    }

    private static TimeValue parse(Matcher matcher, Supplier<ZoneId> defaultZone) {
        return new TimeValue(OffsetTime.of(LocalTimeValue.parseTime(matcher), TimeValue.parseOffset(matcher, defaultZone)));
    }

    private static ZoneOffset parseOffset(Matcher matcher, Supplier<ZoneId> defaultZone) {
        ZoneOffset offset = TimeValue.parseOffset(matcher);
        if (offset == null) {
            ZoneId zoneId = defaultZone.get();
            offset = zoneId instanceof ZoneOffset ? (ZoneOffset)zoneId : zoneId.getRules().getOffset(Instant.now());
        }
        return offset;
    }

    static abstract class TimeBuilder<Result>
    extends TemporalValue.Builder<Result> {
        TimeBuilder(Supplier<ZoneId> defaultZone) {
            super(defaultZone);
        }

        @Override
        protected final boolean supportsDate() {
            return false;
        }

        @Override
        protected final boolean supportsTime() {
            return true;
        }

        @Override
        protected boolean supportsEpoch() {
            return false;
        }

        protected abstract Result selectTime(AnyValue var1);
    }
}

