/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.OutputStream;
import java.util.function.Function;
import org.neo4j.io.NullOutputStream;
import org.neo4j.unsafe.impl.batchimport.input.BadCollector;
import org.neo4j.unsafe.impl.batchimport.input.Collector;

public class Collectors {
    private Collectors() {
    }

    public static Collector silentBadCollector(long tolerance) {
        return Collectors.silentBadCollector(tolerance, 7);
    }

    public static Collector silentBadCollector(long tolerance, int collect2) {
        return Collectors.badCollector(NullOutputStream.NULL_OUTPUT_STREAM, tolerance, collect2);
    }

    public static Collector badCollector(OutputStream out, long unlimitedTolerance) {
        return Collectors.badCollector(out, unlimitedTolerance, 7, false);
    }

    public static Collector badCollector(OutputStream out, long tolerance, int collect2) {
        return new BadCollector(out, tolerance, collect2, 10000, false, BadCollector.NO_MONITOR);
    }

    public static Collector badCollector(OutputStream out, long unlimitedTolerance, int collect2, boolean skipBadEntriesLogging) {
        return new BadCollector(out, unlimitedTolerance, collect2, 10000, skipBadEntriesLogging, BadCollector.NO_MONITOR);
    }

    public static Function<OutputStream, Collector> badCollector(int tolerance) {
        return Collectors.badCollector(tolerance, 7);
    }

    public static Function<OutputStream, Collector> badCollector(int tolerance, int collect2) {
        return out -> Collectors.badCollector(out, tolerance, collect2, false);
    }

    public static int collect(boolean skipBadRelationships, boolean skipDuplicateNodes, boolean ignoreExtraColumns) {
        return (skipBadRelationships ? 1 : 0) | (skipDuplicateNodes ? 2 : 0) | (ignoreExtraColumns ? 4 : 0);
    }
}

