/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.helpers.Format;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;

public class GatheringMemoryStatsVisitor
implements MemoryStatsVisitor {
    private long heapUsage;
    private long offHeapUsage;

    @Override
    public void heapUsage(long bytes2) {
        this.heapUsage += bytes2;
    }

    @Override
    public void offHeapUsage(long bytes2) {
        this.offHeapUsage += bytes2;
    }

    public long getHeapUsage() {
        return this.heapUsage;
    }

    public long getOffHeapUsage() {
        return this.offHeapUsage;
    }

    public long getTotalUsage() {
        return this.heapUsage + this.offHeapUsage;
    }

    public String toString() {
        return "Memory usage[heap:" + Format.bytes(this.heapUsage) + ", off-heap:" + Format.bytes(this.offHeapUsage) + "]";
    }

    public static long totalMemoryUsageOf(MemoryStatsVisitor.Visitable ... memoryUsers) {
        GatheringMemoryStatsVisitor memoryVisitor = new GatheringMemoryStatsVisitor();
        for (MemoryStatsVisitor.Visitable memoryUser : memoryUsers) {
            memoryUser.acceptMemoryStatsVisitor(memoryVisitor);
        }
        return memoryVisitor.getTotalUsage();
    }

    public static long highestMemoryUsageOf(MemoryStatsVisitor.Visitable ... memoryUsers) {
        long max2 = 0L;
        for (MemoryStatsVisitor.Visitable visitable : memoryUsers) {
            max2 = Long.max(max2, GatheringMemoryStatsVisitor.totalMemoryUsageOf(visitable));
        }
        return max2;
    }
}

