/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.nio.ByteBuffer;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.DynamicNumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class DynamicByteArray
extends DynamicNumberArray<ByteArray>
implements ByteArray {
    private final byte[] defaultValue;
    private final ByteBuffer defaultValueConvenienceBuffer;

    public DynamicByteArray(NumberArrayFactory factory, long chunkSize, byte[] defaultValue) {
        super(factory, chunkSize, (NumberArray[])new ByteArray[0]);
        this.defaultValue = defaultValue;
        this.defaultValueConvenienceBuffer = ByteBuffer.wrap(defaultValue);
    }

    @Override
    public void swap(long fromIndex, long toIndex) {
        ByteArray fromArray = (ByteArray)this.at(fromIndex);
        ByteArray toArray2 = (ByteArray)this.at(toIndex);
        for (int i = 0; i < this.defaultValue.length; ++i) {
            byte intermediary = fromArray.getByte(fromIndex, i);
            fromArray.setByte(fromIndex, i, toArray2.getByte(toIndex, i));
            toArray2.setByte(toIndex, i, intermediary);
        }
    }

    @Override
    public void get(long index, byte[] into) {
        ByteArray chunk = (ByteArray)this.chunkOrNullAt(index);
        if (chunk != null) {
            chunk.get(index, into);
        } else {
            System.arraycopy(this.defaultValue, 0, into, 0, this.defaultValue.length);
        }
    }

    @Override
    public byte getByte(long index, int offset) {
        ByteArray chunk = (ByteArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.getByte(index, offset) : this.defaultValueConvenienceBuffer.get(offset);
    }

    @Override
    public short getShort(long index, int offset) {
        ByteArray chunk = (ByteArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.getShort(index, offset) : this.defaultValueConvenienceBuffer.getShort(offset);
    }

    @Override
    public int getInt(long index, int offset) {
        ByteArray chunk = (ByteArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.getInt(index, offset) : this.defaultValueConvenienceBuffer.getInt(offset);
    }

    @Override
    public int get3ByteInt(long index, int offset) {
        ByteArray chunk = (ByteArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.get3ByteInt(index, offset) : HeapByteArray.get3ByteIntFromByteBuffer(this.defaultValueConvenienceBuffer, offset);
    }

    @Override
    public long get5ByteLong(long index, int offset) {
        ByteArray chunk = (ByteArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.get5ByteLong(index, offset) : HeapByteArray.get5BLongFromByteBuffer(this.defaultValueConvenienceBuffer, offset);
    }

    @Override
    public long get6ByteLong(long index, int offset) {
        ByteArray chunk = (ByteArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.get6ByteLong(index, offset) : HeapByteArray.get6BLongFromByteBuffer(this.defaultValueConvenienceBuffer, offset);
    }

    @Override
    public long getLong(long index, int offset) {
        ByteArray chunk = (ByteArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.getLong(index, offset) : this.defaultValueConvenienceBuffer.getLong(offset);
    }

    @Override
    public void set(long index, byte[] value2) {
        ((ByteArray)this.at(index)).set(index, value2);
    }

    @Override
    public void setByte(long index, int offset, byte value2) {
        ((ByteArray)this.at(index)).setByte(index, offset, value2);
    }

    @Override
    public void setShort(long index, int offset, short value2) {
        ((ByteArray)this.at(index)).setShort(index, offset, value2);
    }

    @Override
    public void setInt(long index, int offset, int value2) {
        ((ByteArray)this.at(index)).setInt(index, offset, value2);
    }

    @Override
    public void set5ByteLong(long index, int offset, long value2) {
        ((ByteArray)this.at(index)).set5ByteLong(index, offset, value2);
    }

    @Override
    public void set6ByteLong(long index, int offset, long value2) {
        ((ByteArray)this.at(index)).set6ByteLong(index, offset, value2);
    }

    @Override
    public void setLong(long index, int offset, long value2) {
        ((ByteArray)this.at(index)).setLong(index, offset, value2);
    }

    @Override
    public void set3ByteInt(long index, int offset, int value2) {
        ((ByteArray)this.at(index)).set3ByteInt(index, offset, value2);
    }

    @Override
    protected ByteArray addChunk(long chunkSize, long base) {
        return this.factory.newByteArray(chunkSize, this.defaultValue, base);
    }
}

