/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.util.statistics.IntCounter;
import org.neo4j.kernel.impl.util.statistics.LocalIntCounter;

public class RecordChanges<RECORD, ADDITIONAL>
implements RecordAccess<RECORD, ADDITIONAL> {
    private MutableLongObjectMap<RecordAccess.RecordProxy<RECORD, ADDITIONAL>> recordChanges = new LongObjectHashMap();
    private final RecordAccess.Loader<RECORD, ADDITIONAL> loader;
    private final IntCounter changeCounter;

    public RecordChanges(RecordAccess.Loader<RECORD, ADDITIONAL> loader, IntCounter globalCounter) {
        this.loader = loader;
        this.changeCounter = new LocalIntCounter(globalCounter);
    }

    public String toString() {
        return "RecordChanges{recordChanges=" + this.recordChanges + '}';
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> getIfLoaded(long key) {
        return (RecordAccess.RecordProxy)this.recordChanges.get(key);
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> getOrLoad(long key, ADDITIONAL additionalData) {
        RecordChange<RECORD, ADDITIONAL> result2 = (RecordChange<RECORD, ADDITIONAL>)this.recordChanges.get(key);
        if (result2 == null) {
            RECORD record = this.loader.load(key, additionalData);
            result2 = new RecordChange<RECORD, ADDITIONAL>(this.recordChanges, this.changeCounter, key, record, this.loader, false, additionalData);
        }
        return result2;
    }

    @Override
    public void setTo(long key, RECORD newRecord, ADDITIONAL additionalData) {
        this.setRecord(key, newRecord, additionalData);
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> setRecord(long key, RECORD record, ADDITIONAL additionalData) {
        RecordChange<RECORD, ADDITIONAL> recordChange = new RecordChange<RECORD, ADDITIONAL>(this.recordChanges, this.changeCounter, key, record, this.loader, false, additionalData);
        this.recordChanges.put(key, recordChange);
        return recordChange;
    }

    @Override
    public int changeSize() {
        return this.changeCounter.value();
    }

    @Override
    public void close() {
        if (this.recordChanges.size() <= 32) {
            this.recordChanges.clear();
        } else {
            this.recordChanges = new LongObjectHashMap();
        }
        this.changeCounter.clear();
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> create(long key, ADDITIONAL additionalData) {
        if (this.recordChanges.containsKey(key)) {
            throw new IllegalStateException(key + " already exists");
        }
        RECORD record = this.loader.newUnused(key, additionalData);
        RecordChange<RECORD, ADDITIONAL> change = new RecordChange<RECORD, ADDITIONAL>(this.recordChanges, this.changeCounter, key, record, this.loader, true, additionalData);
        this.recordChanges.put(key, change);
        return change;
    }

    @Override
    public Iterable<RecordAccess.RecordProxy<RECORD, ADDITIONAL>> changes() {
        return Iterables.filter(RecordAccess.RecordProxy::isChanged, (Iterable)this.recordChanges.values());
    }

    public static class RecordChange<RECORD, ADDITIONAL>
    implements RecordAccess.RecordProxy<RECORD, ADDITIONAL> {
        private final MutableLongObjectMap<RecordAccess.RecordProxy<RECORD, ADDITIONAL>> allChanges;
        private final IntCounter changeCounter;
        private final RecordAccess.Loader<RECORD, ADDITIONAL> loader;
        private final ADDITIONAL additionalData;
        private final RECORD record;
        private final boolean created;
        private final long key;
        private RECORD before;
        private boolean changed;

        public RecordChange(MutableLongObjectMap<RecordAccess.RecordProxy<RECORD, ADDITIONAL>> allChanges, IntCounter changeCounter, long key, RECORD record, RecordAccess.Loader<RECORD, ADDITIONAL> loader, boolean created, ADDITIONAL additionalData) {
            this.allChanges = allChanges;
            this.changeCounter = changeCounter;
            this.key = key;
            this.record = record;
            this.loader = loader;
            this.created = created;
            this.additionalData = additionalData;
        }

        public String toString() {
            return "RecordChange{record=" + this.record + "key=" + this.key + "created=" + this.created + '}';
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        public RECORD forChangingLinkage() {
            return this.prepareForChange();
        }

        @Override
        public RECORD forChangingData() {
            this.ensureHeavy();
            return this.prepareForChange();
        }

        private RECORD prepareForChange() {
            this.ensureHasBeforeRecordImage();
            if (!this.changed) {
                RecordAccess.RecordProxy previous = (RecordAccess.RecordProxy)this.allChanges.put(this.key, (Object)this);
                if (previous == null || !previous.isChanged()) {
                    this.changeCounter.increment();
                }
                this.changed = true;
            }
            return this.record;
        }

        private void ensureHeavy() {
            if (!this.created) {
                this.loader.ensureHeavy(this.record);
                if (this.before != null) {
                    this.loader.ensureHeavy(this.before);
                }
            }
        }

        @Override
        public RECORD forReadingLinkage() {
            return this.record;
        }

        @Override
        public RECORD forReadingData() {
            this.ensureHeavy();
            return this.record;
        }

        @Override
        public boolean isChanged() {
            return this.changed;
        }

        @Override
        public RECORD getBefore() {
            this.ensureHasBeforeRecordImage();
            return this.before;
        }

        private void ensureHasBeforeRecordImage() {
            if (this.before == null) {
                this.before = this.loader.clone(this.record);
            }
        }

        @Override
        public boolean isCreated() {
            return this.created;
        }

        @Override
        public ADDITIONAL getAdditionalData() {
            return this.additionalData;
        }
    }
}

