/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.neo4j.kernel.impl.api.KernelTransactionsSnapshot;
import org.neo4j.kernel.impl.store.id.DelayedBuffer;
import org.neo4j.kernel.impl.store.id.IdGenerator;

class BufferingIdGenerator
extends IdGenerator.Delegate {
    private DelayedBuffer<KernelTransactionsSnapshot> buffer;

    BufferingIdGenerator(IdGenerator delegate) {
        super(delegate);
    }

    void initialize(Supplier<KernelTransactionsSnapshot> boundaries, Predicate<KernelTransactionsSnapshot> safeThreshold) {
        this.buffer = new DelayedBuffer<KernelTransactionsSnapshot>(boundaries, safeThreshold, 10000, freedIds -> {
            for (long id2 : freedIds) {
                this.actualFreeId(id2);
            }
        });
    }

    private void actualFreeId(long id2) {
        super.freeId(id2);
    }

    @Override
    public void freeId(long id2) {
        this.buffer.offer(id2);
    }

    void maintenance() {
        this.buffer.maintenance();
    }

    void clear() {
        this.buffer.clear();
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
        }
        super.close();
    }
}

