/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.graphdb.security.URLAccessValidationError;

class FileURLAccessRule
implements URLAccessRule {
    FileURLAccessRule() {
    }

    @Override
    public URL validate(Configuration config, URL url) throws URLAccessValidationError {
        if (url.getAuthority() != null && !url.getAuthority().equals("")) {
            throw new URLAccessValidationError("file URL may not contain an authority section (i.e. it should be 'file:///')");
        }
        if (url.getQuery() != null && !url.getQuery().equals("")) {
            throw new URLAccessValidationError("file URL may not contain a query component");
        }
        if (!config.get(GraphDatabaseSettings.allow_file_urls).booleanValue()) {
            throw new URLAccessValidationError("configuration property '" + GraphDatabaseSettings.allow_file_urls.name() + "' is false");
        }
        File root2 = config.get(GraphDatabaseSettings.load_csv_file_url_root);
        if (root2 == null) {
            return url;
        }
        try {
            Path urlPath = Paths.get(url.toURI());
            Path rootPath = root2.toPath().normalize().toAbsolutePath();
            Path result2 = rootPath.resolve(urlPath.getRoot().relativize(urlPath)).normalize().toAbsolutePath();
            if (result2.startsWith(rootPath)) {
                return result2.toUri().toURL();
            }
            throw new URLAccessValidationError("file URL points outside configured import directory");
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

