/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.kernel.impl.scheduler.ThreadPoolManager;
import org.neo4j.kernel.impl.scheduler.TimeBasedTaskScheduler;
import org.neo4j.scheduler.CancelListener;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.util.concurrent.BinaryLatch;

final class ScheduledJobHandle
extends AtomicInteger
implements JobHandle {
    private static final int RUNNABLE = 0;
    private static final int SUBMITTED = 1;
    private static final int FAILED = 2;
    long nextDeadlineNanos;
    private final Group group;
    private final CopyOnWriteArrayList<CancelListener> cancelListeners;
    private final BinaryLatch handleRelease;
    private final Runnable task;
    private volatile JobHandle latestHandle;
    private volatile Throwable lastException;

    ScheduledJobHandle(TimeBasedTaskScheduler scheduler, Group group, Runnable task, long nextDeadlineNanos, long reschedulingDelayNanos) {
        this.group = group;
        this.nextDeadlineNanos = nextDeadlineNanos;
        this.handleRelease = new BinaryLatch();
        this.cancelListeners = new CopyOnWriteArrayList();
        this.task = () -> {
            try {
                task.run();
                if (this.compareAndSet(1, 0) && reschedulingDelayNanos > 0L) {
                    this.nextDeadlineNanos += reschedulingDelayNanos;
                    scheduler.enqueueTask(this);
                }
            }
            catch (Throwable e) {
                this.lastException = e;
                this.set(2);
            }
        };
    }

    void submitIfRunnable(ThreadPoolManager pools) {
        if (this.compareAndSet(0, 1)) {
            this.latestHandle = pools.submit(this.group, this.task);
            this.handleRelease.release();
        }
    }

    @Override
    public void cancel(boolean mayInterruptIfRunning) {
        this.set(2);
        JobHandle handle = this.latestHandle;
        if (handle != null) {
            handle.cancel(mayInterruptIfRunning);
        }
        for (CancelListener cancelListener : this.cancelListeners) {
            cancelListener.cancelled(mayInterruptIfRunning);
        }
        this.handleRelease.release();
    }

    @Override
    public void waitTermination() throws ExecutionException, InterruptedException {
        this.handleRelease.await();
        JobHandle handleDelegate = this.latestHandle;
        if (handleDelegate != null) {
            handleDelegate.waitTermination();
        }
        if (this.get() == 2) {
            Throwable exception = this.lastException;
            if (exception != null) {
                throw new ExecutionException(exception);
            }
            throw new CancellationException();
        }
    }

    @Override
    public void registerCancelListener(CancelListener listener) {
        this.cancelListeners.add(listener);
    }
}

