/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.function.Supplier;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.values.virtual.MapValue;

public class Neo4jTransactionalContextFactory
implements TransactionalContextFactory {
    private final Supplier<Statement> statementSupplier;
    private final Neo4jTransactionalContext.Creator contextCreator;

    public static TransactionalContextFactory create(GraphDatabaseFacade.SPI spi, ThreadToStatementContextBridge txBridge, PropertyContainerLocker locker) {
        Suppliers.Lazy<GraphDatabaseQueryService> queryService = Suppliers.lazySingleton(spi::queryService);
        Suppliers.Lazy<Kernel> kernel = Suppliers.lazySingleton(spi::kernel);
        Neo4jTransactionalContext.Creator contextCreator = (tx, initialStatement, executingQuery) -> new Neo4jTransactionalContext((GraphDatabaseQueryService)queryService.get(), txBridge, locker, tx, initialStatement, executingQuery, (Kernel)kernel.get());
        return new Neo4jTransactionalContextFactory(txBridge, contextCreator);
    }

    @Deprecated
    public static TransactionalContextFactory create(GraphDatabaseQueryService queryService, PropertyContainerLocker locker) {
        DependencyResolver resolver = queryService.getDependencyResolver();
        ThreadToStatementContextBridge txBridge = resolver.resolveDependency(ThreadToStatementContextBridge.class);
        Kernel kernel = resolver.resolveDependency(Kernel.class);
        Neo4jTransactionalContext.Creator contextCreator = (tx, initialStatement, executingQuery) -> new Neo4jTransactionalContext(queryService, txBridge, locker, tx, initialStatement, executingQuery, kernel);
        return new Neo4jTransactionalContextFactory(txBridge, contextCreator);
    }

    private Neo4jTransactionalContextFactory(Supplier<Statement> statementSupplier, Neo4jTransactionalContext.Creator contextCreator) {
        this.statementSupplier = statementSupplier;
        this.contextCreator = contextCreator;
    }

    @Override
    public final Neo4jTransactionalContext newContext(ClientConnectionInfo clientConnection, InternalTransaction tx, String queryText, MapValue queryParameters) {
        Statement initialStatement = this.statementSupplier.get();
        ClientConnectionInfo connectionWithUserName = clientConnection.withUsername(tx.securityContext().subject().username());
        ExecutingQuery executingQuery = initialStatement.queryRegistration().startQueryExecution(connectionWithUserName, queryText, queryParameters);
        return this.contextCreator.create(tx, initialStatement, executingQuery);
    }
}

