/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.function.Consumer;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;

class InstanceSelector<T> {
    final EnumMap<IndexSlot, T> instances;
    boolean closed;

    InstanceSelector() {
        this(new EnumMap(IndexSlot.class));
    }

    InstanceSelector(EnumMap<IndexSlot, T> map2) {
        this.instances = map2;
    }

    void put(IndexSlot slot, T instance2) {
        this.instances.put(slot, instance2);
    }

    T select(IndexSlot slot) {
        if (!this.instances.containsKey((Object)slot)) {
            throw new IllegalStateException("Instance is not instantiated");
        }
        return this.instances.get((Object)slot);
    }

    <R, E extends Exception> EnumMap<IndexSlot, R> map(ThrowingFunction<T, R, E> converter) throws E {
        EnumMap<IndexSlot, R> result2 = new EnumMap<IndexSlot, R>(IndexSlot.class);
        for (IndexSlot slot : IndexSlot.values()) {
            result2.put(slot, converter.apply(this.select(slot)));
        }
        return result2;
    }

    <R, E extends Exception> Iterable<R> transform(ThrowingFunction<T, R, E> converter) throws E {
        ArrayList<R> result2 = new ArrayList<R>();
        for (IndexSlot slot : IndexSlot.values()) {
            result2.add(converter.apply(this.select(slot)));
        }
        return result2;
    }

    void forAll(Consumer<T> consumer) {
        RuntimeException exception = null;
        for (IndexSlot slot : IndexSlot.values()) {
            exception = this.consumeAndChainException(this.select(slot), consumer, exception);
        }
        if (exception != null) {
            throw exception;
        }
    }

    void close(Consumer<T> consumer) {
        if (!this.closed) {
            try {
                this.forInstantiated(consumer);
            }
            finally {
                this.closed = true;
            }
        }
    }

    public String toString() {
        return this.instances.toString();
    }

    private void forInstantiated(Consumer<T> consumer) {
        RuntimeException exception = null;
        for (T instance2 : this.instances.values()) {
            if (instance2 == null) continue;
            exception = this.consumeAndChainException(instance2, consumer, exception);
        }
        if (exception != null) {
            throw exception;
        }
    }

    private RuntimeException consumeAndChainException(T instance2, Consumer<T> consumer, RuntimeException exception) {
        try {
            consumer.accept(instance2);
        }
        catch (RuntimeException e) {
            exception = Exceptions.chain(exception, e);
        }
        return exception;
    }
}

