/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.configuration.ConfigValue;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.values.storable.CoordinateReferenceSystem;

class EnvelopeSettings {
    private static final String SPATIAL_SETTING_PREFIX = "unsupported.dbms.db.spatial.crs.";
    private static final double DEFAULT_MIN_EXTENT = -1000000.0;
    private static final double DEFAULT_MAX_EXTENT = 1000000.0;
    private static final double DEFAULT_MIN_LATITUDE = -90.0;
    private static final double DEFAULT_MAX_LATITUDE = 90.0;
    private static final double DEFAULT_MIN_LONGITUDE = -180.0;
    private static final double DEFAULT_MAX_LONGITUDE = 180.0;
    private CoordinateReferenceSystem crs;
    private double[] min;
    private double[] max;

    EnvelopeSettings(CoordinateReferenceSystem crs) {
        this.crs = crs;
        this.min = new double[crs.getDimension()];
        this.max = new double[crs.getDimension()];
        Arrays.fill(this.min, Double.NaN);
        Arrays.fill(this.max, Double.NaN);
    }

    static HashMap<CoordinateReferenceSystem, EnvelopeSettings> envelopeSettingsFromConfig(Config config) {
        HashMap<CoordinateReferenceSystem, EnvelopeSettings> env = new HashMap<CoordinateReferenceSystem, EnvelopeSettings>();
        block8: for (Map.Entry<String, ConfigValue> entry : config.getConfigValues().entrySet()) {
            String key = entry.getKey();
            String value2 = entry.getValue().toString();
            if (!key.startsWith(SPATIAL_SETTING_PREFIX)) continue;
            String[] fields = key.replace(SPATIAL_SETTING_PREFIX, "").split("\\.");
            if (fields.length != 3) {
                throw new IllegalArgumentException("Invalid spatial config settings, expected three fields after 'unsupported.dbms.db.spatial.crs.': " + key);
            }
            CoordinateReferenceSystem crs = CoordinateReferenceSystem.byName(fields[0]);
            EnvelopeSettings envelopeSettings = env.computeIfAbsent(crs, EnvelopeSettings::new);
            int index = "xyz".indexOf(fields[1].toLowerCase());
            if (index < 0) {
                throw new IllegalArgumentException("Invalid spatial coordinate key (should be one of 'x', 'y' or 'z'): " + fields[1]);
            }
            if (index >= crs.getDimension()) {
                throw new IllegalArgumentException("Invalid spatial coordinate key for " + crs.getDimension() + "D: " + fields[1]);
            }
            switch (fields[2].toLowerCase()) {
                case "min": {
                    envelopeSettings.min[index] = Double.parseDouble(value2);
                    continue block8;
                }
                case "max": {
                    envelopeSettings.max[index] = Double.parseDouble(value2);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Invalid spatial coordinate range key (should be one of 'max' or 'min'): " + fields[2]);
        }
        return env;
    }

    Envelope asEnvelope() {
        int dimension = this.crs.getDimension();
        assert (dimension >= 2);
        double[] min2 = new double[dimension];
        double[] max2 = new double[dimension];
        int cartesianStartIndex = 0;
        if (this.crs.isGeographic()) {
            min2[0] = this.minOrDefault(0, -180.0);
            max2[0] = this.maxOrDefault(0, 180.0);
            min2[1] = this.minOrDefault(1, -90.0);
            max2[1] = this.maxOrDefault(1, 90.0);
            cartesianStartIndex = 2;
        }
        for (int i = cartesianStartIndex; i < dimension; ++i) {
            min2[i] = this.minOrDefault(i, -1000000.0);
            max2[i] = this.maxOrDefault(i, 1000000.0);
        }
        return new Envelope(min2, max2);
    }

    CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    private double minOrDefault(int i, double defVal) {
        return EnvelopeSettings.valOrDefault(this.min[i], defVal);
    }

    private double maxOrDefault(int i, double defVal) {
        return EnvelopeSettings.valOrDefault(this.max[i], defVal);
    }

    private static double valOrDefault(double val, double def) {
        return Double.isNaN(val) ? def : val;
    }
}

