/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SpatialIndexAccessor;
import org.neo4j.kernel.impl.index.schema.SpatialIndexCache;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;

public class SpatialIndexUpdater
extends SpatialIndexCache<NativeIndexUpdater<?, NativeIndexValue>>
implements IndexUpdater {
    SpatialIndexUpdater(SpatialIndexAccessor accessor, IndexUpdateMode mode) {
        super(new PartFactory(accessor, mode));
    }

    @Override
    public void process(IndexEntryUpdate<?> update2) throws IndexEntryConflictException {
        IndexUpdater to2 = (IndexUpdater)this.select(((PointValue)update2.values()[0]).getCoordinateReferenceSystem());
        switch (update2.updateMode()) {
            case ADDED: 
            case REMOVED: {
                to2.process(update2);
                break;
            }
            case CHANGED: {
                IndexUpdater from2 = (IndexUpdater)this.select(((PointValue)update2.beforeValues()[0]).getCoordinateReferenceSystem());
                if (from2 == to2) {
                    from2.process(update2);
                    break;
                }
                from2.process(IndexEntryUpdate.remove(update2.getEntityId(), update2.indexKey(), update2.beforeValues()));
                to2.process(IndexEntryUpdate.add(update2.getEntityId(), update2.indexKey(), update2.values()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update mode");
            }
        }
    }

    @Override
    public void close() {
        FusionIndexBase.forAll(NativeIndexUpdater::close, this);
    }

    static class PartFactory
    implements SpatialIndexCache.Factory<NativeIndexUpdater<?, NativeIndexValue>> {
        private final SpatialIndexAccessor accessor;
        private final IndexUpdateMode mode;

        PartFactory(SpatialIndexAccessor accessor, IndexUpdateMode mode) {
            this.accessor = accessor;
            this.mode = mode;
        }

        @Override
        public NativeIndexUpdater<?, NativeIndexValue> newSpatial(CoordinateReferenceSystem crs) {
            return ((SpatialIndexAccessor.PartAccessor)this.accessor.select(crs)).newUpdater(this.mode);
        }
    }
}

