/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Map;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

final class SpatialIndexConfig {
    private static final String SPATIAL_CONFIG_PREFIX = "spatial";

    private SpatialIndexConfig() {
    }

    static void addSpatialConfig(Map<String, Value> map2, CoordinateReferenceSystem crs, SpaceFillingCurveSettings settings) {
        String crsName = crs.getName();
        int tableId = crs.getTable().getTableId();
        int code = crs.getCode();
        int dimensions = settings.getDimensions();
        int maxLevels = settings.getMaxLevels();
        double[] min2 = settings.indexExtents().getMin();
        double[] max2 = settings.indexExtents().getMax();
        String prefix = SpatialIndexConfig.prefix(crsName);
        map2.put(prefix + ".tableId", Values.intValue(tableId));
        map2.put(prefix + ".code", Values.intValue(code));
        map2.put(prefix + ".dimensions", Values.intValue(dimensions));
        map2.put(prefix + ".maxLevels", Values.intValue(maxLevels));
        map2.put(prefix + ".min", Values.doubleArray(min2));
        map2.put(prefix + ".max", Values.doubleArray(max2));
    }

    private static String prefix(String crsName) {
        return "spatial." + crsName;
    }
}

