/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.LocalTime;
import java.util.StringJoiner;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class LocalTimeType
extends Type {
    LocalTimeType(byte typeId) {
        super(ValueGroup.LOCAL_TIME, typeId, LocalTimeValue.MIN_VALUE, LocalTimeValue.MAX_VALUE);
    }

    @Override
    int valueSize(GenericKey state) {
        return 8;
    }

    @Override
    void copyValue(GenericKey to2, GenericKey from2) {
        to2.long0 = from2.long0;
    }

    @Override
    Value asValue(GenericKey state) {
        return LocalTimeType.asValue(state.long0);
    }

    @Override
    int compareValue(GenericKey left2, GenericKey right2) {
        return LocalTimeType.compare(left2.long0, right2.long0);
    }

    @Override
    void putValue(PageCursor cursor, GenericKey state) {
        LocalTimeType.put(cursor, state.long0);
    }

    @Override
    boolean readValue(PageCursor cursor, int size2, GenericKey into) {
        return LocalTimeType.read(cursor, into);
    }

    static LocalTimeValue asValue(long long0) {
        return LocalTimeValue.localTime(LocalTimeType.asValueRaw(long0));
    }

    static LocalTime asValueRaw(long long0) {
        return LocalTimeValue.localTimeRaw(long0);
    }

    static int compare(long this_long0, long that_long0) {
        return Long.compare(this_long0, that_long0);
    }

    static void put(PageCursor cursor, long long0) {
        cursor.putLong(long0);
    }

    static boolean read(PageCursor cursor, GenericKey into) {
        into.writeLocalTime(cursor.getLong());
        return true;
    }

    void write(GenericKey state, long nanoOfDay) {
        state.long0 = nanoOfDay;
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey state) {
        joiner.add("long0=" + state.long0);
    }
}

