/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.StringJoiner;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class BooleanType
extends Type {
    BooleanType(byte typeId) {
        super(ValueGroup.BOOLEAN, typeId, Values.of(false), Values.of(true));
    }

    @Override
    int valueSize(GenericKey state) {
        return 1;
    }

    @Override
    void copyValue(GenericKey to2, GenericKey from2) {
        to2.long0 = from2.long0;
    }

    @Override
    Value asValue(GenericKey state) {
        return BooleanType.asValue(state.long0);
    }

    @Override
    int compareValue(GenericKey left2, GenericKey right2) {
        return BooleanType.compare(left2.long0, right2.long0);
    }

    @Override
    void putValue(PageCursor cursor, GenericKey state) {
        BooleanType.put(cursor, state.long0);
    }

    @Override
    boolean readValue(PageCursor cursor, int size2, GenericKey into) {
        return BooleanType.read(cursor, into);
    }

    static BooleanValue asValue(long long0) {
        return Values.booleanValue(BooleanType.asValueRaw(long0));
    }

    static boolean asValueRaw(long long0) {
        return BooleanType.booleanOf(long0);
    }

    static int compare(long this_long0, long that_long0) {
        return Long.compare(this_long0, that_long0);
    }

    static void put(PageCursor cursor, long long0) {
        cursor.putByte((byte)long0);
    }

    static boolean read(PageCursor cursor, GenericKey into) {
        into.writeBoolean((long)cursor.getByte() == 1L);
        return true;
    }

    void write(GenericKey state, boolean value2) {
        state.long0 = value2 ? 1L : 0L;
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey state) {
        joiner.add("long0=" + state.long0);
    }
}

