/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.LoggingMonitor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;

public abstract class AbstractIndexProviderFactory<DEPENDENCIES extends Dependencies>
extends KernelExtensionFactory<DEPENDENCIES> {
    protected AbstractIndexProviderFactory(String key) {
        super(ExtensionType.DATABASE, key);
    }

    @Override
    public IndexProvider newInstance(KernelContext context, DEPENDENCIES dependencies2) {
        PageCache pageCache = dependencies2.pageCache();
        File databaseDir = context.directory();
        FileSystemAbstraction fs = dependencies2.fileSystem();
        Log log = dependencies2.getLogService().getInternalLogProvider().getLog(this.loggingClass());
        Monitors monitors = dependencies2.monitors();
        monitors.addMonitorListener(new LoggingMonitor(log), this.descriptorString());
        IndexProvider.Monitor monitor = monitors.newMonitor(IndexProvider.Monitor.class, this.descriptorString());
        Config config = dependencies2.getConfig();
        OperationalMode operationalMode = context.databaseInfo().operationalMode;
        RecoveryCleanupWorkCollector recoveryCleanupWorkCollector = dependencies2.recoveryCleanupWorkCollector();
        return this.internalCreate(pageCache, databaseDir, fs, monitor, config, operationalMode, recoveryCleanupWorkCollector);
    }

    protected abstract Class loggingClass();

    protected abstract String descriptorString();

    protected abstract IndexProvider internalCreate(PageCache var1, File var2, FileSystemAbstraction var3, IndexProvider.Monitor var4, Config var5, OperationalMode var6, RecoveryCleanupWorkCollector var7);

    public static interface Dependencies {
        public PageCache pageCache();

        public FileSystemAbstraction fileSystem();

        public LogService getLogService();

        public Monitors monitors();

        public Config getConfig();

        public RecoveryCleanupWorkCollector recoveryCleanupWorkCollector();
    }
}

