/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;

public class PathProxy
implements Path {
    private final EmbeddedProxySPI proxySPI;
    private final long[] nodes;
    private final long[] relationships;
    private final int[] directedTypes;

    public PathProxy(EmbeddedProxySPI proxySPI, long[] nodes, long[] relationships, int[] directedTypes) {
        assert (nodes.length == relationships.length + 1);
        assert (relationships.length == directedTypes.length);
        this.proxySPI = proxySPI;
        this.nodes = nodes;
        this.relationships = relationships;
        this.directedTypes = directedTypes;
    }

    @Override
    public String toString() {
        StringBuilder string2 = new StringBuilder();
        string2.append('(').append(this.nodes[0]).append(')');
        boolean inTx = true;
        for (int i = 0; i < this.relationships.length; ++i) {
            int type = this.directedTypes[i];
            string2.append(type < 0 ? "<-[" : "-[");
            string2.append(this.relationships[i]);
            if (inTx) {
                try {
                    String name = this.proxySPI.getRelationshipTypeById(type < 0 ? ~type : type).name();
                    string2.append(':').append(name);
                }
                catch (Exception e) {
                    inTx = false;
                }
            }
            string2.append(type < 0 ? "]-(" : "]->(").append(this.nodes[i + 1]).append(')');
        }
        return string2.toString();
    }

    public int hashCode() {
        if (this.relationships.length == 0) {
            return Long.hashCode(this.nodes[0]);
        }
        return Arrays.hashCode(this.relationships);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PathProxy) {
            PathProxy that = (PathProxy)obj;
            return Arrays.equals(this.nodes, that.nodes) && Arrays.equals(this.relationships, that.relationships);
        }
        if (obj instanceof Path) {
            Path other2 = (Path)obj;
            if (this.nodes[0] != other2.startNode().getId()) {
                return false;
            }
            return Iterators.iteratorsEqual(this.relationships().iterator(), other2.relationships().iterator());
        }
        return false;
    }

    @Override
    public Node startNode() {
        return new NodeProxy(this.proxySPI, this.nodes[0]);
    }

    @Override
    public Node endNode() {
        return new NodeProxy(this.proxySPI, this.nodes[this.nodes.length - 1]);
    }

    @Override
    public Relationship lastRelationship() {
        return this.relationships.length == 0 ? null : this.relationship(this.relationships.length - 1);
    }

    private RelationshipProxy relationship(int offset) {
        int type = this.directedTypes[offset];
        if (type >= 0) {
            return new RelationshipProxy(this.proxySPI, this.relationships[offset], this.nodes[offset], type, this.nodes[offset + 1]);
        }
        return new RelationshipProxy(this.proxySPI, this.relationships[offset], this.nodes[offset + 1], ~type, this.nodes[offset]);
    }

    @Override
    public Iterable<Relationship> relationships() {
        return () -> new Iterator<Relationship>(){
            int i;

            @Override
            public boolean hasNext() {
                return this.i < PathProxy.this.relationships.length;
            }

            @Override
            public Relationship next() {
                return PathProxy.this.relationship(this.i++);
            }
        };
    }

    @Override
    public Iterable<Relationship> reverseRelationships() {
        return () -> new Iterator<Relationship>(){
            int i;
            {
                this.i = PathProxy.this.relationships.length;
            }

            @Override
            public boolean hasNext() {
                return this.i > 0;
            }

            @Override
            public Relationship next() {
                return PathProxy.this.relationship(--this.i);
            }
        };
    }

    @Override
    public Iterable<Node> nodes() {
        return () -> new Iterator<Node>(){
            int i;

            @Override
            public boolean hasNext() {
                return this.i < PathProxy.this.nodes.length;
            }

            @Override
            public Node next() {
                return new NodeProxy(PathProxy.this.proxySPI, PathProxy.this.nodes[this.i++]);
            }
        };
    }

    @Override
    public Iterable<Node> reverseNodes() {
        return () -> new Iterator<Node>(){
            int i;
            {
                this.i = PathProxy.this.nodes.length;
            }

            @Override
            public boolean hasNext() {
                return this.i > 0;
            }

            @Override
            public Node next() {
                return new NodeProxy(PathProxy.this.proxySPI, PathProxy.this.nodes[--this.i]);
            }
        };
    }

    @Override
    public int length() {
        return this.relationships.length;
    }

    @Override
    public Iterator<PropertyContainer> iterator() {
        return new Iterator<PropertyContainer>(){
            int i;
            boolean relationship;

            @Override
            public boolean hasNext() {
                return this.i < PathProxy.this.relationships.length || !this.relationship;
            }

            @Override
            public PropertyContainer next() {
                if (this.relationship) {
                    this.relationship = false;
                    return PathProxy.this.relationship(this.i++);
                }
                this.relationship = true;
                return new NodeProxy(PathProxy.this.proxySPI, PathProxy.this.nodes[this.i]);
            }
        };
    }
}

