/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Arrays;
import java.util.function.LongPredicate;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

public class LookupFilter {
    private LookupFilter() {
    }

    public static LongIterator exactIndexMatches(NodePropertyAccessor accessor, LongIterator indexedNodeIds, IndexQuery ... predicates) {
        if (!indexedNodeIds.hasNext()) {
            return indexedNodeIds;
        }
        IndexQuery[] filteredPredicates = (IndexQuery[])Arrays.stream(predicates).filter(LookupFilter::isNumericOrGeometricPredicate).toArray(IndexQuery[]::new);
        if (filteredPredicates.length > 0) {
            LongPredicate combinedPredicate = nodeId -> {
                try {
                    for (IndexQuery predicate : filteredPredicates) {
                        int propertyKeyId = predicate.propertyKeyId();
                        Value value2 = accessor.getNodePropertyValue(nodeId, propertyKeyId);
                        if (predicate.acceptsValue(value2)) continue;
                        return false;
                    }
                    return true;
                }
                catch (EntityNotFoundException ignored) {
                    return false;
                }
            };
            return PrimitiveLongCollections.filter((LongIterator)indexedNodeIds, (LongPredicate)combinedPredicate);
        }
        return indexedNodeIds;
    }

    private static boolean isNumericOrGeometricPredicate(IndexQuery predicate) {
        if (predicate.type() == IndexQuery.IndexQueryType.exact) {
            IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicate;
            return LookupFilter.isNumberGeometryOrArray(exactPredicate.value());
        }
        return predicate.type() == IndexQuery.IndexQueryType.range && (predicate.valueGroup() == ValueGroup.NUMBER || predicate.valueGroup() == ValueGroup.GEOMETRY);
    }

    private static boolean isNumberGeometryOrArray(Value value2) {
        return Values.isNumberValue(value2) || Values.isGeometryValue(value2) || Values.isArrayValue(value2);
    }
}

