/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.MultiTokenSchemaDescriptor;
import org.neo4j.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.storageengine.api.EntityType;

public class SchemaDescriptorFactory {
    private SchemaDescriptorFactory() {
    }

    public static LabelSchemaDescriptor forLabel(int labelId, int ... propertyIds) {
        SchemaDescriptorFactory.validateLabelIds(labelId);
        SchemaDescriptorFactory.validatePropertyIds(propertyIds);
        return new LabelSchemaDescriptor(labelId, propertyIds);
    }

    public static RelationTypeSchemaDescriptor forRelType(int relTypeId, int ... propertyIds) {
        SchemaDescriptorFactory.validateRelationshipTypeIds(relTypeId);
        SchemaDescriptorFactory.validatePropertyIds(propertyIds);
        return new RelationTypeSchemaDescriptor(relTypeId, propertyIds);
    }

    public static MultiTokenSchemaDescriptor multiToken(int[] entityTokens, EntityType entityType, int ... propertyIds) {
        SchemaDescriptorFactory.validatePropertyIds(propertyIds);
        switch (entityType) {
            case NODE: {
                SchemaDescriptorFactory.validateLabelIds(entityTokens);
                break;
            }
            case RELATIONSHIP: {
                SchemaDescriptorFactory.validateRelationshipTypeIds(entityTokens);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot create schemadescriptor of type :" + entityType);
            }
        }
        return new MultiTokenSchemaDescriptor(entityTokens, entityType, propertyIds);
    }

    private static void validatePropertyIds(int[] propertyIds) {
        for (int propertyId : propertyIds) {
            if (-1 != propertyId) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent property.");
        }
    }

    private static void validateRelationshipTypeIds(int ... relTypes) {
        for (int relType : relTypes) {
            if (-1 != relType) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent relationship type.");
        }
    }

    private static void validateLabelIds(int ... labelIds) {
        for (int labelId : labelIds) {
            if (-1 != labelId) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent label.");
        }
    }
}

