/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;

public class DefaultComparatorTopTable<T>
implements Iterable<T> {
    private final Comparator<T> comparator;
    private final int totalCount;
    private int count = -1;
    private PriorityQueue<T> heap;
    private Object[] array;

    public DefaultComparatorTopTable(Comparator<T> comparator2, int totalCount) {
        this.comparator = comparator2;
        if (totalCount <= 0) {
            throw new IllegalArgumentException("Top table size must be greater than 0");
        }
        this.totalCount = totalCount;
        this.heap = new PriorityQueue<T>(Math.min(totalCount, 1024), comparator2.reversed());
    }

    public boolean add(T e) {
        if (this.heap.size() < this.totalCount) {
            return this.heap.offer(e);
        }
        T head2 = this.heap.peek();
        if (this.comparator.compare(head2, e) > 0) {
            this.heap.poll();
            return this.heap.offer(e);
        }
        return false;
    }

    public void sort() {
        this.count = this.heap.size();
        this.array = new Object[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.array[i] = this.heap.poll();
        }
    }

    @Override
    public Iterator<T> iterator() {
        if (this.count == -1) {
            throw new IllegalStateException("sort() needs to be called before requesting an iterator");
        }
        return new Iterator<T>(){
            private int cursor;
            {
                this.cursor = DefaultComparatorTopTable.this.count;
            }

            @Override
            public boolean hasNext() {
                return this.cursor > 0;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int offset = --this.cursor;
                return DefaultComparatorTopTable.this.array[offset];
            }
        };
    }
}

