/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.internal;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Subparsers;
import net.sourceforge.argparse4j.internal.ArgumentParserImpl;
import net.sourceforge.argparse4j.internal.ParseState;
import net.sourceforge.argparse4j.internal.SubparserImpl;
import net.sourceforge.argparse4j.internal.UnrecognizedCommandException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubparsersImpl
implements Subparsers {
    private ArgumentParserImpl mainParser_;
    private Map<String, SubparserImpl> parsers_ = new LinkedHashMap<String, SubparserImpl>();
    private String help_ = "";
    private String title_ = "";
    private String description_ = "";
    private String dest_ = "";
    private String metavar_ = "";

    public SubparsersImpl(ArgumentParserImpl mainParser) {
        this.mainParser_ = mainParser;
    }

    @Override
    public SubparserImpl addParser(String command) {
        return this.addParser(command, true, this.mainParser_.getPrefixChars());
    }

    @Override
    public SubparserImpl addParser(String command, boolean addHelp) {
        return this.addParser(command, addHelp, this.mainParser_.getPrefixChars());
    }

    @Override
    public SubparserImpl addParser(String command, boolean addHelp, String prefixChars) {
        if (command == null || command.isEmpty()) {
            throw new IllegalArgumentException("command cannot be null or empty");
        }
        if (this.parsers_.containsKey(command)) {
            throw new IllegalArgumentException(String.format(TextHelper.LOCALE_ROOT, "command '%s' has been already used", command));
        }
        SubparserImpl parser = new SubparserImpl(this.mainParser_.getProg(), addHelp, prefixChars, this.mainParser_.getFromFilePrefixChars(), this.mainParser_.getTextWidthCounter(), command, this.mainParser_);
        this.parsers_.put(command, parser);
        return parser;
    }

    @Override
    public SubparsersImpl dest(String dest) {
        this.dest_ = TextHelper.nonNull(dest);
        return this;
    }

    @Override
    public SubparsersImpl help(String help2) {
        this.help_ = TextHelper.nonNull(help2);
        return this;
    }

    @Override
    public SubparsersImpl title(String title) {
        this.title_ = TextHelper.nonNull(title);
        return this;
    }

    public String getTitle() {
        return this.title_;
    }

    @Override
    public SubparsersImpl description(String description) {
        this.description_ = TextHelper.nonNull(description);
        return this;
    }

    public String getDescription() {
        return this.description_;
    }

    @Override
    public SubparsersImpl metavar(String metavar) {
        this.metavar_ = TextHelper.nonNull(metavar);
        return this;
    }

    public boolean hasSubCommand() {
        return !this.parsers_.isEmpty();
    }

    private SubparserImpl resolveNextSubparser(ParseState state, String command) throws ArgumentParserException {
        if (command.isEmpty()) {
            return null;
        }
        SubparserImpl ap = this.parsers_.get(command);
        if (ap == null) {
            List<String> cand = TextHelper.findPrefix(this.parsers_.keySet(), command);
            int size2 = cand.size();
            if (size2 == 1) {
                ap = this.parsers_.get(cand.get(0));
            } else if (size2 > 1) {
                Collections.sort(cand);
                throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, "ambiguous command: %s could match %s", command, TextHelper.concat(cand, 0, ", ")), (ArgumentParser)this.mainParser_);
            }
        }
        return ap;
    }

    public void parseArg(ParseState state, Map<String, Object> opts) throws ArgumentParserException {
        if (this.parsers_.isEmpty()) {
            throw new IllegalArgumentException("too many arguments");
        }
        SubparserImpl ap = this.resolveNextSubparser(state, state.getArg());
        if (ap == null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, SubparserImpl> entry : this.parsers_.entrySet()) {
                sb.append("'").append(entry.getKey()).append("', ");
            }
            sb.delete(sb.length() - 2, sb.length());
            throw new UnrecognizedCommandException(String.format(TextHelper.LOCALE_ROOT, "invalid choice: '%s' (choose from %s)", state.getArg(), sb.toString()), (ArgumentParser)this.mainParser_, state.getArg());
        }
        ++state.index;
        ap.parseArgs(state, opts);
        if (!this.dest_.isEmpty()) {
            opts.put(this.dest_, ap.getCommand());
        }
    }

    public String formatShortSyntax() {
        if (this.metavar_.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (Map.Entry<String, SubparserImpl> entry : this.parsers_.entrySet()) {
                sb.append(entry.getKey()).append(",");
            }
            if (sb.length() > 1) {
                sb.delete(sb.length() - 1, sb.length());
            }
            sb.append("}");
            return sb.toString();
        }
        return this.metavar_;
    }

    public void printSubparserHelp(PrintWriter writer, int format_width) {
        TextHelper.printHelp(writer, this.formatShortSyntax(), this.help_, this.mainParser_.getTextWidthCounter(), format_width);
        for (Map.Entry<String, SubparserImpl> entry : this.parsers_.entrySet()) {
            if (!entry.getKey().equals(entry.getValue().getCommand())) continue;
            entry.getValue().printSubparserHelp(writer, format_width);
        }
    }

    public Collection<String> getCommands() {
        return this.parsers_.keySet();
    }

    public void addAlias(SubparserImpl subparser, String ... alias) {
        for (String command : alias) {
            if (this.parsers_.containsKey(command)) {
                throw new IllegalArgumentException(String.format(TextHelper.LOCALE_ROOT, "command '%s' has been already used", command));
            }
            this.parsers_.put(command, subparser);
        }
    }
}

