/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.neo4j.jmx.Kernel;
import org.neo4j.jmx.impl.JmxKernelExtension;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.NonTransactionProvidingApp;
import org.neo4j.shell.util.json.JSONArray;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;

public class Dbinfo
extends NonTransactionProvidingApp {
    public Dbinfo() {
        this.addOptionDefinition("l", new OptionDefinition(OptionValueType.MAY, "List available attributes for the specified bean. Including a description about each attribute."));
        this.addOptionDefinition("g", new OptionDefinition(OptionValueType.MUST, "Get the value of the specified attribute(s), or all attributes of the specified bean if no attributes are specified."));
    }

    @Override
    public String getDescription() {
        Kernel kernel;
        try {
            kernel = this.getKernel();
        }
        catch (ShellException e) {
            return e.getMessage();
        }
        MBeanServer mbeans = ManagementFactory.getPlatformMBeanServer();
        StringBuilder result = new StringBuilder("Get runtime information about the Graph Database.\nThis uses the ONgDB management beans to get information about the Graph Database.\n\n");
        this.availableBeans(mbeans, kernel, result);
        result.append("\n");
        this.getUsage(result);
        return result.toString();
    }

    private void getUsage(StringBuilder result) {
        result.append("USAGE: ");
        result.append(this.getName());
        result.append(" -(g|l) <bean name> [list of attribute names]");
    }

    private Kernel getKernel() throws ShellException {
        GraphDatabaseAPI graphDb = this.getServer().getDb();
        Kernel kernel = null;
        if (graphDb instanceof GraphDatabaseAPI) {
            try {
                kernel = (Kernel)((JmxKernelExtension)graphDb.getDependencyResolver().resolveDependency(JmxKernelExtension.class)).getSingleManagementBean(Kernel.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (kernel == null) {
            throw new ShellException(this.getName() + " is not available for this graph database.");
        }
        return kernel;
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws Exception {
        Kernel kernel = this.getKernel();
        boolean list = parser.options().containsKey("l");
        boolean get = parser.options().containsKey("g");
        if (list && get || !list && !get) {
            StringBuilder usage = new StringBuilder();
            this.getUsage(usage);
            usage.append(".\n");
            out.print((Serializable)((Object)usage.toString()));
            return Continuation.INPUT_COMPLETE;
        }
        MBeanServer mbeans = ManagementFactory.getPlatformMBeanServer();
        String bean = null;
        String[] attributes = null;
        if (list) {
            bean = parser.options().get("l");
        } else if (get) {
            bean = parser.options().get("g");
            attributes = parser.arguments().toArray(new String[parser.arguments().size()]);
        }
        if (bean == null) {
            StringBuilder result = new StringBuilder();
            this.availableBeans(mbeans, kernel, result);
            out.print((Serializable)((Object)result.toString()));
            return Continuation.INPUT_COMPLETE;
        }
        ObjectName mbean = kernel.getMBeanQuery();
        MBeanAttributeInfo[] properties = new Hashtable(mbean.getKeyPropertyList());
        properties.put((String)"name", (String)bean);
        try {
            Iterator<ObjectName> names = mbeans.queryNames(new ObjectName(mbean.getDomain(), (Hashtable<String, String>)properties), null).iterator();
            if (names.hasNext()) {
                mbean = names.next();
                if (names.hasNext()) {
                    mbean = null;
                }
            } else {
                mbean = null;
            }
        }
        catch (Exception e) {
            mbean = null;
        }
        if (mbean == null) {
            throw new ShellException("No such management bean \"" + bean + "\".");
        }
        if (attributes == null) {
            for (MBeanAttributeInfo attr : mbeans.getMBeanInfo(mbean).getAttributes()) {
                out.println((Serializable)((Object)(attr.getName() + " - " + attr.getDescription())));
            }
        } else {
            if (attributes.length == 0) {
                MBeanAttributeInfo[] allAttributes = mbeans.getMBeanInfo(mbean).getAttributes();
                attributes = new String[allAttributes.length];
                for (int i = 0; i < allAttributes.length; ++i) {
                    attributes[i] = allAttributes[i].getName();
                }
            }
            JSONObject json = new JSONObject();
            for (Object value : mbeans.getAttributes(mbean, attributes)) {
                this.printAttribute(json, value);
            }
            out.println((Serializable)((Object)json.toString(2)));
        }
        return Continuation.INPUT_COMPLETE;
    }

    private void printAttribute(JSONObject json, Object value) throws ShellException {
        try {
            Attribute attribute = (Attribute)value;
            Object attributeValue = attribute.getValue();
            if (attributeValue != null && attributeValue.getClass().isArray()) {
                Object[] arrayValue = (Object[])attributeValue;
                JSONArray array = new JSONArray();
                for (Object item : arrayValue) {
                    if (item instanceof CompositeData) {
                        array.put(this.compositeDataAsMap((CompositeData)item));
                        continue;
                    }
                    array.put(item.toString());
                }
                json.put(attribute.getName(), array);
            } else {
                json.put(attribute.getName(), attributeValue);
            }
        }
        catch (JSONException e) {
            throw ShellException.wrapCause(e);
        }
    }

    private Map<?, ?> compositeDataAsMap(CompositeData item) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : item.getCompositeType().keySet()) {
            result.put(key, item.get(key));
        }
        return result;
    }

    private void availableBeans(MBeanServer mbeans, Kernel kernel, StringBuilder result) {
        result.append("Available Management Beans\n");
        for (ObjectName name : mbeans.queryNames(kernel.getMBeanQuery(), null)) {
            result.append("* ");
            result.append(name.getKeyProperty("name"));
            result.append("\n");
        }
    }
}

