/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import java.io.File;
import java.time.Clock;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.jmx.StoreFile;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.jmx.impl.StoreSizeBean;
import org.neo4j.jmx.impl.ThrottlingBeanSnapshotProxy;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;

public final class StoreFileBean
extends ManagementBeanProvider {
    private static final long UPDATE_INTERVAL = 60000L;
    private static final StoreFile NO_STORE_FILE = new StoreFile(){

        @Override
        public long getLogicalLogSize() {
            return 0L;
        }

        @Override
        public long getTotalStoreSize() {
            return 0L;
        }

        @Override
        public long getNodeStoreSize() {
            return 0L;
        }

        @Override
        public long getRelationshipStoreSize() {
            return 0L;
        }

        @Override
        public long getPropertyStoreSize() {
            return 0L;
        }

        @Override
        public long getStringStoreSize() {
            return 0L;
        }

        @Override
        public long getArrayStoreSize() {
            return 0L;
        }
    };

    public StoreFileBean() {
        super(StoreFile.class);
    }

    @Override
    protected Neo4jMBean createMBean(ManagementData management) {
        StoreFileMBean bean = new StoreFileMBean(management);
        DataSourceManager dataSourceManager = (DataSourceManager)management.resolveDependency(DataSourceManager.class);
        dataSourceManager.addListener((DataSourceManager.Listener)bean);
        return bean;
    }

    static class StoreFileImpl
    implements StoreFile {
        private static final String NODE_STORE = "neostore.nodestore.db";
        private static final String RELATIONSHIP_STORE = "neostore.relationshipstore.db";
        private static final String PROPERTY_STORE = "neostore.propertystore.db";
        private static final String ARRAY_STORE = "neostore.propertystore.db.arrays";
        private static final String STRING_STORE = "neostore.propertystore.db.strings";
        private final File storePath;
        private final LogFiles logFiles;
        private final FileSystemAbstraction fs;

        StoreFileImpl(FileSystemAbstraction fs, File storePath, LogFiles logFiles) {
            this.fs = fs;
            this.storePath = storePath;
            this.logFiles = logFiles;
        }

        @Override
        public long getTotalStoreSize() {
            return this.storePath == null ? 0L : FileUtils.size((FileSystemAbstraction)this.fs, (File)this.storePath);
        }

        @Override
        public long getLogicalLogSize() {
            return this.logFiles == null ? 0L : FileUtils.size((FileSystemAbstraction)this.fs, (File)this.logFiles.getHighestLogFile());
        }

        @Override
        public long getArrayStoreSize() {
            return this.sizeOf(ARRAY_STORE);
        }

        @Override
        public long getNodeStoreSize() {
            return this.sizeOf(NODE_STORE);
        }

        @Override
        public long getPropertyStoreSize() {
            return this.sizeOf(PROPERTY_STORE);
        }

        @Override
        public long getRelationshipStoreSize() {
            return this.sizeOf(RELATIONSHIP_STORE);
        }

        @Override
        public long getStringStoreSize() {
            return this.sizeOf(STRING_STORE);
        }

        private long sizeOf(String name) {
            return this.storePath == null ? 0L : FileUtils.size((FileSystemAbstraction)this.fs, (File)new File(this.storePath, name));
        }
    }

    static class StoreFileMBean
    extends Neo4jMBean
    implements StoreFile,
    DataSourceManager.Listener {
        private final FileSystemAbstraction fs;
        private final File storePath;
        private volatile StoreFile delegate = StoreFileBean.access$000();

        StoreFileMBean(ManagementData management) {
            super(management, false, new String[0]);
            this.fs = management.getKernelData().getFilesystemAbstraction();
            this.storePath = StoreSizeBean.resolveStorePath(management);
        }

        public void registered(NeoStoreDataSource ds) {
            LogFiles logFiles = (LogFiles)ds.getDependencyResolver().resolveDependency(LogFiles.class);
            StoreFileImpl dataProvider = new StoreFileImpl(this.fs, this.storePath, logFiles);
            this.delegate = ThrottlingBeanSnapshotProxy.newThrottlingBeanSnapshotProxy(StoreFile.class, dataProvider, 60000L, Clock.systemUTC());
        }

        public void unregistered(NeoStoreDataSource ds) {
            this.delegate = NO_STORE_FILE;
        }

        @Override
        public long getLogicalLogSize() {
            return this.delegate.getLogicalLogSize();
        }

        @Override
        public long getTotalStoreSize() {
            return this.delegate.getTotalStoreSize();
        }

        @Override
        public long getNodeStoreSize() {
            return this.delegate.getNodeStoreSize();
        }

        @Override
        public long getRelationshipStoreSize() {
            return this.delegate.getRelationshipStoreSize();
        }

        @Override
        public long getPropertyStoreSize() {
            return this.delegate.getPropertyStoreSize();
        }

        @Override
        public long getStringStoreSize() {
            return this.delegate.getStringStoreSize();
        }

        @Override
        public long getArrayStoreSize() {
            return this.delegate.getArrayStoreSize();
        }
    }
}

