/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.stream.StreamSupport;
import org.neo4j.function.ThrowingBiConsumer;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValueGroup;
import org.neo4j.values.virtual.VirtualValues;

public abstract class MapValue
extends VirtualValue {
    public static MapValue EMPTY = new MapValue(){

        @Override
        public Iterable<String> keySet() {
            return Collections.emptyList();
        }

        @Override
        public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) {
        }

        @Override
        public boolean containsKey(String key) {
            return false;
        }

        @Override
        public AnyValue get(String key) {
            return Values.NO_VALUE;
        }

        @Override
        public int size() {
            return 0;
        }
    };

    @Override
    public int computeHash() {
        int[] h = new int[1];
        this.foreach((key, value2) -> {
            h[0] = h[0] + (key.hashCode() ^ value2.hashCode());
        });
        return h[0];
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        writer.beginMap(this.size());
        this.foreach((s2, anyValue) -> {
            writer.writeString((String)s2);
            anyValue.writeTo(writer);
        });
        writer.endMap();
    }

    @Override
    public boolean equals(VirtualValue other2) {
        if (!(other2 instanceof MapValue)) {
            return false;
        }
        MapValue that = (MapValue)other2;
        int size2 = this.size();
        if (size2 != that.size()) {
            return false;
        }
        Iterable<String> keys = this.keySet();
        for (String key : keys) {
            if (this.get(key).equals(that.get(key))) continue;
            return false;
        }
        return true;
    }

    public abstract Iterable<String> keySet();

    public ListValue keys() {
        String[] keys = new String[this.size()];
        int i = 0;
        for (String key : this.keySet()) {
            keys[i++] = key;
        }
        return VirtualValues.fromArray(Values.stringArray(keys));
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.MAP;
    }

    @Override
    public int compareTo(VirtualValue other2, Comparator<AnyValue> comparator2) {
        if (!(other2 instanceof MapValue)) {
            throw new IllegalArgumentException("Cannot compare different virtual values");
        }
        MapValue otherMap = (MapValue)other2;
        int size2 = this.size();
        int compare = Integer.compare(size2, otherMap.size());
        if (compare == 0) {
            int i;
            String[] thisKeys = (String[])StreamSupport.stream(this.keySet().spliterator(), false).toArray(String[]::new);
            Arrays.sort(thisKeys, String::compareTo);
            String[] thatKeys = (String[])StreamSupport.stream(otherMap.keySet().spliterator(), false).toArray(String[]::new);
            Arrays.sort(thatKeys, String::compareTo);
            for (i = 0; i < size2; ++i) {
                compare = thisKeys[i].compareTo(thatKeys[i]);
                if (compare == 0) continue;
                return compare;
            }
            for (i = 0; i < size2; ++i) {
                String key = thisKeys[i];
                compare = comparator2.compare(this.get(key), otherMap.get(key));
                if (compare == 0) continue;
                return compare;
            }
        }
        return compare;
    }

    @Override
    public Boolean ternaryEquals(AnyValue other2) {
        if (other2 == null || other2 == Values.NO_VALUE) {
            return null;
        }
        if (!(other2 instanceof MapValue)) {
            return Boolean.FALSE;
        }
        MapValue otherMap = (MapValue)other2;
        int size2 = this.size();
        if (size2 != otherMap.size()) {
            return Boolean.FALSE;
        }
        String[] thisKeys = (String[])StreamSupport.stream(this.keySet().spliterator(), false).toArray(String[]::new);
        Arrays.sort(thisKeys, String::compareTo);
        String[] thatKeys = (String[])StreamSupport.stream(otherMap.keySet().spliterator(), false).toArray(String[]::new);
        Arrays.sort(thatKeys, String::compareTo);
        for (int i = 0; i < size2; ++i) {
            if (thisKeys[i].compareTo(thatKeys[i]) == 0) continue;
            return Boolean.FALSE;
        }
        Boolean equalityResult = Boolean.TRUE;
        for (int i = 0; i < size2; ++i) {
            String key = thisKeys[i];
            Boolean s2 = this.get(key).ternaryEquals(otherMap.get(key));
            if (s2 == null) {
                equalityResult = null;
                continue;
            }
            if (s2.booleanValue()) continue;
            return Boolean.FALSE;
        }
        return equalityResult;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapMap(this);
    }

    public abstract <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> var1) throws E;

    public abstract boolean containsKey(String var1);

    public abstract AnyValue get(String var1);

    public MapValue filter(BiFunction<String, AnyValue, Boolean> filterFunction) {
        return new FilteringMapValue(this, filterFunction);
    }

    public MapValue updatedWith(String key, AnyValue value2) {
        AnyValue current = this.get(key);
        if (current.equals(value2)) {
            return this;
        }
        if (current == Values.NO_VALUE) {
            return new UpdatedMapValue(this, new String[]{key}, new AnyValue[]{value2});
        }
        return new MappedMapValue(this, (k, v) -> {
            if (k.equals(key)) {
                return value2;
            }
            return v;
        });
    }

    public MapValue updatedWith(MapValue other2) {
        return new CombinedMapValue(this, other2);
    }

    @Override
    public String getTypeName() {
        return "Map";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getTypeName() + "{");
        String[] sep = new String[]{""};
        this.foreach((key, value2) -> {
            sb.append(sep[0]);
            sb.append((String)key);
            sb.append(" -> ");
            sb.append(value2);
            sep[0] = ", ";
        });
        sb.append('}');
        return sb.toString();
    }

    public abstract int size();

    private static final class CombinedMapValue
    extends MapValue {
        private final MapValue[] maps;

        CombinedMapValue(MapValue ... mapValues) {
            this.maps = mapValues;
        }

        @Override
        public Iterable<String> keySet() {
            return () -> new PrefetchingIterator<String>(){
                private int mapIndex;
                private Iterator internal;
                private HashSet seen = new HashSet();

                protected String fetchNextOrNull() {
                    while (this.mapIndex < maps.length || this.internal != null && this.internal.hasNext()) {
                        if (this.internal == null || !this.internal.hasNext()) {
                            this.internal = maps[this.mapIndex++].keySet().iterator();
                        }
                        while (this.internal.hasNext()) {
                            String key = (String)this.internal.next();
                            if (!this.seen.add(key)) continue;
                            return key;
                        }
                    }
                    return null;
                }
            };
        }

        @Override
        public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) throws E {
            HashSet seen = new HashSet();
            ThrowingBiConsumer consume = (key, value2) -> {
                if (seen.add(key)) {
                    f.accept((String)key, (AnyValue)value2);
                }
            };
            for (int i = this.maps.length - 1; i >= 0; --i) {
                this.maps[i].foreach(consume);
            }
        }

        @Override
        public boolean containsKey(String key) {
            for (MapValue map2 : this.maps) {
                if (!map2.containsKey(key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public AnyValue get(String key) {
            for (int i = this.maps.length - 1; i >= 0; --i) {
                AnyValue value2 = this.maps[i].get(key);
                if (value2 == Values.NO_VALUE) continue;
                return value2;
            }
            return Values.NO_VALUE;
        }

        @Override
        public int size() {
            int[] size2 = new int[]{0};
            HashSet seen = new HashSet();
            ThrowingBiConsumer consume = (key, value2) -> {
                if (seen.add(key)) {
                    size2[0] = size2[0] + 1;
                }
            };
            for (int i = this.maps.length - 1; i >= 0; --i) {
                this.maps[i].foreach(consume);
            }
            return size2[0];
        }
    }

    private static final class UpdatedMapValue
    extends MapValue {
        private final MapValue map;
        private final String[] updatedKeys;
        private final AnyValue[] updatedValues;

        UpdatedMapValue(MapValue map2, String[] updatedKeys, AnyValue[] updatedValues) {
            assert (updatedKeys.length == updatedValues.length);
            assert (!UpdatedMapValue.overlaps(map2, updatedKeys));
            this.map = map2;
            this.updatedKeys = updatedKeys;
            this.updatedValues = updatedValues;
        }

        private static boolean overlaps(MapValue map2, String[] updatedKeys) {
            for (String key : updatedKeys) {
                if (!map2.containsKey(key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ListValue keys() {
            return VirtualValues.concat(this.map.keys(), VirtualValues.fromArray(Values.stringArray(this.updatedKeys)));
        }

        @Override
        public Iterable<String> keySet() {
            return () -> new Iterator<String>(){
                private int index;
                private Iterator internal;
                {
                    this.internal = map.keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.internal.hasNext()) {
                        return true;
                    }
                    return this.index < updatedKeys.length;
                }

                @Override
                public String next() {
                    if (this.internal.hasNext()) {
                        return (String)this.internal.next();
                    }
                    if (this.index < updatedKeys.length) {
                        return updatedKeys[this.index++];
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) throws E {
            this.map.foreach(f);
            for (int i = 0; i < this.updatedKeys.length; ++i) {
                f.accept(this.updatedKeys[i], this.updatedValues[i]);
            }
        }

        @Override
        public boolean containsKey(String key) {
            for (String updatedKey : this.updatedKeys) {
                if (!updatedKey.equals(key)) continue;
                return true;
            }
            return this.map.containsKey(key);
        }

        @Override
        public AnyValue get(String key) {
            for (int i = 0; i < this.updatedKeys.length; ++i) {
                if (!this.updatedKeys[i].equals(key)) continue;
                return this.updatedValues[i];
            }
            return this.map.get(key);
        }

        @Override
        public int size() {
            return this.map.size() + this.updatedKeys.length;
        }
    }

    private static final class MappedMapValue
    extends MapValue {
        private final MapValue map;
        private final BiFunction<String, AnyValue, AnyValue> mapFunction;

        MappedMapValue(MapValue map2, BiFunction<String, AnyValue, AnyValue> mapFunction) {
            this.map = map2;
            this.mapFunction = mapFunction;
        }

        @Override
        public ListValue keys() {
            return this.map.keys();
        }

        @Override
        public Iterable<String> keySet() {
            return this.map.keySet();
        }

        @Override
        public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) throws E {
            this.map.foreach((s2, anyValue) -> f.accept((String)s2, this.mapFunction.apply((String)s2, (AnyValue)anyValue)));
        }

        @Override
        public boolean containsKey(String key) {
            return this.map.containsKey(key);
        }

        @Override
        public AnyValue get(String key) {
            return this.mapFunction.apply(key, this.map.get(key));
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    private static final class FilteringMapValue
    extends MapValue {
        private final MapValue map;
        private final BiFunction<String, AnyValue, Boolean> filter;
        private int size = -1;

        FilteringMapValue(MapValue map2, BiFunction<String, AnyValue, Boolean> filter2) {
            this.map = map2;
            this.filter = filter2;
        }

        @Override
        public Iterable<String> keySet() {
            ArrayList<String> keys = this.size >= 0 ? new ArrayList<String>(this.size) : new ArrayList();
            this.foreach((key, value2) -> {
                if (this.filter.apply((String)key, (AnyValue)value2).booleanValue()) {
                    keys.add((String)key);
                }
            });
            return keys;
        }

        @Override
        public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) throws E {
            this.map.foreach((s2, anyValue) -> {
                if (this.filter.apply((String)s2, (AnyValue)anyValue).booleanValue()) {
                    f.accept((String)s2, (AnyValue)anyValue);
                }
            });
        }

        @Override
        public boolean containsKey(String key) {
            AnyValue value2 = this.map.get(key);
            if (value2 == Values.NO_VALUE) {
                return false;
            }
            return this.filter.apply(key, value2);
        }

        @Override
        public AnyValue get(String key) {
            AnyValue value2 = this.map.get(key);
            if (value2 == Values.NO_VALUE) {
                return Values.NO_VALUE;
            }
            if (this.filter.apply(key, value2).booleanValue()) {
                return value2;
            }
            return Values.NO_VALUE;
        }

        @Override
        public int size() {
            if (this.size < 0) {
                this.size = 0;
                this.foreach((k, v) -> {
                    if (this.filter.apply((String)k, (AnyValue)v).booleanValue()) {
                        ++this.size;
                    }
                });
            }
            return this.size;
        }
    }

    static final class MapWrappingMapValue
    extends MapValue {
        private final Map<String, AnyValue> map;

        MapWrappingMapValue(Map<String, AnyValue> map2) {
            this.map = map2;
        }

        @Override
        public Iterable<String> keySet() {
            return this.map.keySet();
        }

        @Override
        public <E extends Exception> void foreach(ThrowingBiConsumer<String, AnyValue, E> f) throws E {
            for (Map.Entry<String, AnyValue> entry : this.map.entrySet()) {
                f.accept(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public boolean containsKey(String key) {
            return this.map.containsKey(key);
        }

        @Override
        public AnyValue get(String key) {
            return this.map.getOrDefault(key, Values.NO_VALUE);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }
}

