/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Objects;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.values.storable.CRSCalculator;
import org.neo4j.values.storable.CRSTable;
import org.neo4j.values.utils.InvalidValuesArgumentException;

public class CoordinateReferenceSystem
implements CRS {
    public static final CoordinateReferenceSystem Cartesian = new CoordinateReferenceSystem("cartesian", CRSTable.SR_ORG, 7203, 2, false);
    public static final CoordinateReferenceSystem Cartesian_3D = new CoordinateReferenceSystem("cartesian-3d", CRSTable.SR_ORG, 9157, 3, false);
    public static final CoordinateReferenceSystem WGS84 = new CoordinateReferenceSystem("wgs-84", CRSTable.EPSG, 4326, 2, true);
    public static final CoordinateReferenceSystem WGS84_3D = new CoordinateReferenceSystem("wgs-84-3d", CRSTable.EPSG, 4979, 3, true);
    private static final CoordinateReferenceSystem[] TYPES = new CoordinateReferenceSystem[]{Cartesian, Cartesian_3D, WGS84, WGS84_3D};
    private final String name;
    private final CRSTable table;
    private final int code;
    private final String href;
    private final int dimension;
    private final boolean geographic;
    private final CRSCalculator calculator;

    public static Iterable<CoordinateReferenceSystem> all() {
        return Iterables.asIterable((Object[])TYPES);
    }

    public static CoordinateReferenceSystem get(int tableId, int code) {
        CRSTable table = CRSTable.find(tableId);
        for (CoordinateReferenceSystem type : TYPES) {
            if (type.table != table || type.code != code) continue;
            return type;
        }
        throw new InvalidValuesArgumentException("Unknown coordinate reference system: " + tableId + "-" + code);
    }

    public static CoordinateReferenceSystem get(CRS crs) {
        Objects.requireNonNull(crs);
        return CoordinateReferenceSystem.get(crs.getHref());
    }

    public static CoordinateReferenceSystem byName(String name) {
        for (CoordinateReferenceSystem type : TYPES) {
            if (!type.name.equals(name.toLowerCase())) continue;
            return type;
        }
        throw new InvalidValuesArgumentException("Unknown coordinate reference system: " + name);
    }

    public static CoordinateReferenceSystem get(String href) {
        for (CoordinateReferenceSystem type : TYPES) {
            if (!type.href.equals(href)) continue;
            return type;
        }
        throw new InvalidValuesArgumentException("Unknown coordinate reference system: " + href);
    }

    public static CoordinateReferenceSystem get(int code) {
        for (CRSTable table : CRSTable.values()) {
            String href = table.href(code);
            for (CoordinateReferenceSystem type : TYPES) {
                if (!type.href.equals(href)) continue;
                return type;
            }
        }
        throw new InvalidValuesArgumentException("Unknown coordinate reference system code: " + code);
    }

    private CoordinateReferenceSystem(String name, CRSTable table, int code, int dimension, boolean geographic) {
        assert (name.toLowerCase().equals(name));
        this.name = name;
        this.table = table;
        this.code = code;
        this.href = table.href(code);
        this.dimension = dimension;
        this.geographic = geographic;
        this.calculator = geographic ? new CRSCalculator.GeographicCalculator(dimension) : new CRSCalculator.CartesianCalculator(dimension);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getType() {
        return this.name;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    public String getName() {
        return this.name;
    }

    public CRSTable getTable() {
        return this.table;
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean isGeographic() {
        return this.geographic;
    }

    public CRSCalculator getCalculator() {
        return this.calculator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateReferenceSystem that = (CoordinateReferenceSystem)o;
        return this.href.equals(that.href);
    }

    public int hashCode() {
        return this.href.hashCode();
    }
}

