/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.LongFunction;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.os.OsBeanUtil;
import org.neo4j.kernel.monitoring.VmPauseMonitor;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.SpectrumExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.DetailLevel;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.stats.StepStats;

public class OnDemandDetailsExecutionMonitor
implements ExecutionMonitor {
    private final List<StageDetails> details = new ArrayList<StageDetails>();
    private final PrintStream out;
    private final InputStream in;
    private final Map<String, Pair<String, Runnable>> actions = new HashMap<String, Pair<String, Runnable>>();
    private final VmPauseTimeAccumulator vmPauseTimeAccumulator = new VmPauseTimeAccumulator();
    private final VmPauseMonitor vmPauseMonitor;
    private final Monitor monitor;
    private StageDetails current;
    private boolean printDetailsOnDone;

    public OnDemandDetailsExecutionMonitor(PrintStream out, InputStream in2, Monitor monitor, JobScheduler jobScheduler) {
        this.out = out;
        this.in = in2;
        this.monitor = monitor;
        this.actions.put("i", (Pair<String, Runnable>)Pair.of((Object)"Print more detailed information", this::printDetails));
        this.actions.put("c", (Pair<String, Runnable>)Pair.of((Object)"Print more detailed information about current stage", this::printDetailsForCurrentStage));
        this.vmPauseMonitor = new VmPauseMonitor(Duration.ofMillis(100L), Duration.ofMillis(100L), (Log)NullLog.getInstance(), jobScheduler, this.vmPauseTimeAccumulator);
    }

    @Override
    public void initialize(DependencyResolver dependencyResolver) {
        this.out.println("InteractiveReporterInteractions command list (end with ENTER):");
        this.actions.forEach((key, action) -> this.out.println("  " + key + ": " + (String)action.first()));
        this.out.println();
        this.vmPauseMonitor.start();
    }

    @Override
    public void start(StageExecution execution) {
        this.current = new StageDetails(execution, this.vmPauseTimeAccumulator);
        this.details.add(this.current);
    }

    @Override
    public void end(StageExecution execution, long totalTimeMillis) {
        this.current.collect();
    }

    @Override
    public void done(boolean successful, long totalTimeMillis, String additionalInformation) {
        if (this.printDetailsOnDone) {
            this.printDetails();
        }
        this.vmPauseMonitor.stop();
    }

    @Override
    public long nextCheckTime() {
        return System.currentTimeMillis() + 500L;
    }

    @Override
    public void check(StageExecution execution) {
        this.current.collect();
        this.reactToUserInput();
    }

    private void printDetails() {
        this.printDetailsHeadline();
        long totalTime = 0L;
        for (StageDetails stageDetails : this.details) {
            stageDetails.print(this.out);
            totalTime += stageDetails.totalTimeMillis;
        }
        OnDemandDetailsExecutionMonitor.printIndented(this.out, "Environment information:");
        OnDemandDetailsExecutionMonitor.printIndented(this.out, "  Free physical memory: " + Format.bytes(OsBeanUtil.getFreePhysicalMemory()));
        OnDemandDetailsExecutionMonitor.printIndented(this.out, "  Max VM memory: " + Format.bytes(Runtime.getRuntime().maxMemory()));
        OnDemandDetailsExecutionMonitor.printIndented(this.out, "  Free VM memory: " + Format.bytes(Runtime.getRuntime().freeMemory()));
        OnDemandDetailsExecutionMonitor.printIndented(this.out, "  VM stop-the-world time: " + Format.duration(this.vmPauseTimeAccumulator.getPauseTime()));
        OnDemandDetailsExecutionMonitor.printIndented(this.out, "  Duration: " + Format.duration(totalTime));
        this.out.println();
    }

    private void printDetailsHeadline() {
        this.out.println();
        this.out.println();
        OnDemandDetailsExecutionMonitor.printIndented(this.out, "******** DETAILS " + Format.date() + " ********");
        this.out.println();
        this.printDetailsOnDone = true;
        this.monitor.detailsPrinted();
    }

    private void printDetailsForCurrentStage() {
        this.printDetailsHeadline();
        if (!this.details.isEmpty()) {
            this.details.get(this.details.size() - 1).print(this.out);
        }
    }

    private static void printIndented(PrintStream out, String string2) {
        out.println("\t" + string2);
    }

    private void reactToUserInput() {
        try {
            BufferedReader reader;
            String line;
            Pair<String, Runnable> action;
            if (this.in.available() > 0 && (action = this.actions.get(line = (reader = new BufferedReader(new InputStreamReader(System.in))).readLine())) != null) {
                ((Runnable)action.other()).run();
            }
        }
        catch (IOException e) {
            e.printStackTrace(this.out);
        }
    }

    private static class VmPauseTimeAccumulator
    implements Consumer<VmPauseMonitor.VmPauseInfo> {
        private final AtomicLong totalPauseTime = new AtomicLong();

        private VmPauseTimeAccumulator() {
        }

        @Override
        public void accept(VmPauseMonitor.VmPauseInfo pauseInfo) {
            this.totalPauseTime.addAndGet(pauseInfo.getPauseTime());
        }

        long getPauseTime() {
            return this.totalPauseTime.get();
        }
    }

    private static class StageDetails {
        private final StageExecution execution;
        private final long startTime;
        private final VmPauseTimeAccumulator vmPauseTimeAccumulator;
        private final long baseVmPauseTime;
        private long memoryUsage;
        private long ioThroughput;
        private long totalTimeMillis;
        private long stageVmPauseTime;
        private long doneBatches;

        StageDetails(StageExecution execution, VmPauseTimeAccumulator vmPauseTimeAccumulator) {
            this.execution = execution;
            this.vmPauseTimeAccumulator = vmPauseTimeAccumulator;
            this.baseVmPauseTime = vmPauseTimeAccumulator.getPauseTime();
            this.startTime = System.currentTimeMillis();
        }

        void print(PrintStream out) {
            OnDemandDetailsExecutionMonitor.printIndented(out, this.execution.name());
            StringBuilder builder = new StringBuilder();
            SpectrumExecutionMonitor.printSpectrum(builder, this.execution, 100, DetailLevel.NO);
            OnDemandDetailsExecutionMonitor.printIndented(out, builder.toString());
            StageDetails.printValue(out, this.memoryUsage, "Memory usage", Format::bytes);
            StageDetails.printValue(out, this.ioThroughput, "I/O throughput", value2 -> Format.bytes(value2) + "/s");
            StageDetails.printValue(out, this.stageVmPauseTime, "VM stop-the-world time", Format::duration);
            StageDetails.printValue(out, this.totalTimeMillis, "Duration", Format::duration);
            StageDetails.printValue(out, this.doneBatches, "Done batches", String::valueOf);
            out.println();
        }

        private static void printValue(PrintStream out, long value2, String description, LongFunction<String> toStringConverter) {
            if (value2 > 0L) {
                OnDemandDetailsExecutionMonitor.printIndented(out, description + ": " + toStringConverter.apply(value2));
            }
        }

        void collect() {
            this.totalTimeMillis = System.currentTimeMillis() - this.startTime;
            this.stageVmPauseTime = this.vmPauseTimeAccumulator.getPauseTime() - this.baseVmPauseTime;
            long lastDoneBatches = this.doneBatches;
            for (Step<?> step : this.execution.steps()) {
                Stat ioStat;
                StepStats stats = step.stats();
                Stat memoryUsageStat = stats.stat(Keys.memory_usage);
                if (memoryUsageStat != null) {
                    this.memoryUsage = Long.max(this.memoryUsage, memoryUsageStat.asLong());
                }
                if ((ioStat = stats.stat(Keys.io_throughput)) != null) {
                    this.ioThroughput = ioStat.asLong();
                }
                lastDoneBatches = stats.stat(Keys.done_batches).asLong();
            }
            this.doneBatches = lastDoneBatches;
        }
    }

    static interface Monitor {
        public void detailsPrinted();
    }
}

