/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.HeaderException;

public class Groups {
    static final int LOWEST_NONGLOBAL_ID = 1;
    private final Map<String, Group> byName = new HashMap<String, Group>();
    private final List<Group> byId = new ArrayList<Group>(Arrays.asList(Group.GLOBAL));
    private int nextId = 1;

    public synchronized Group getOrCreate(String name) {
        if (Groups.isGlobalGroup(name)) {
            return Group.GLOBAL;
        }
        Group group = this.byName.get(name);
        if (group == null) {
            group = new Group.Adapter(this.nextId++, name);
            this.byName.put(name, group);
            this.byId.add(group);
        }
        return group;
    }

    private static boolean isGlobalGroup(String name) {
        return name == null || Group.GLOBAL.name().equals(name);
    }

    public synchronized Group get(String name) {
        if (Groups.isGlobalGroup(name)) {
            return Group.GLOBAL;
        }
        Group group = this.byName.get(name);
        if (group == null) {
            throw new HeaderException("Group '" + name + "' not found. Available groups are: " + this.groupNames());
        }
        return group;
    }

    public Group get(int id2) {
        if (id2 < 0 || id2 >= this.byId.size()) {
            throw new HeaderException("Group with id " + id2 + " not found");
        }
        return this.byId.get(id2);
    }

    private String groupNames() {
        return Arrays.toString(this.byName.keySet().toArray(new String[this.byName.keySet().size()]));
    }

    public int size() {
        return this.nextId;
    }
}

