/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.PageCacheByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.PageCacheIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.PageCacheLongArray;

public class PageCachedNumberArrayFactory
extends NumberArrayFactory.Adapter {
    private final PageCache pageCache;
    private final File storeDir;

    public PageCachedNumberArrayFactory(PageCache pageCache, File storeDir) {
        Objects.requireNonNull(pageCache);
        this.pageCache = pageCache;
        this.storeDir = storeDir;
    }

    @Override
    public IntArray newIntArray(long length2, int defaultValue, long base) {
        try {
            File tempFile = File.createTempFile("intArray", ".tmp", this.storeDir);
            PagedFile pagedFile = this.pageCache.map(tempFile, this.pageCache.pageSize(), new OpenOption[]{StandardOpenOption.DELETE_ON_CLOSE, StandardOpenOption.CREATE});
            return new PageCacheIntArray(pagedFile, length2, (long)defaultValue, base);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public LongArray newLongArray(long length2, long defaultValue, long base) {
        try {
            File tempFile = File.createTempFile("longArray", ".tmp", this.storeDir);
            PagedFile pagedFile = this.pageCache.map(tempFile, this.pageCache.pageSize(), new OpenOption[]{StandardOpenOption.DELETE_ON_CLOSE, StandardOpenOption.CREATE});
            return new PageCacheLongArray(pagedFile, length2, defaultValue, base);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public ByteArray newByteArray(long length2, byte[] defaultValue, long base) {
        try {
            File tempFile = File.createTempFile("byteArray", ".tmp", this.storeDir);
            PagedFile pagedFile = this.pageCache.map(tempFile, this.pageCache.pageSize(), new OpenOption[]{StandardOpenOption.DELETE_ON_CLOSE, StandardOpenOption.CREATE});
            return new PageCacheByteArray(pagedFile, length2, defaultValue, base);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

