/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.RecordProcessor;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class RelationshipCountsProcessor
implements RecordProcessor<RelationshipRecord> {
    private final NodeLabelsCache nodeLabelCache;
    private final LongArray labelsCounts;
    private final LongArray wildcardCounts;
    private int[] startScratch = new int[20];
    private int[] endScratch = new int[20];
    private final CountsAccessor.Updater countsUpdater;
    private final long anyLabel;
    private final long anyRelationshipType;
    private final NodeLabelsCache.Client client;
    private final long itemsPerLabel;
    private final long itemsPerType;
    private static final int START = 0;
    private static final int END = 1;
    private static final int SIDES = 2;

    public RelationshipCountsProcessor(NodeLabelsCache nodeLabelCache, int highLabelId, int highRelationshipTypeId, CountsAccessor.Updater countsUpdater, NumberArrayFactory cacheFactory) {
        this.nodeLabelCache = nodeLabelCache;
        this.client = nodeLabelCache.newClient();
        this.countsUpdater = countsUpdater;
        this.anyLabel = highLabelId;
        this.anyRelationshipType = highRelationshipTypeId;
        this.itemsPerType = this.anyLabel + 1L;
        this.itemsPerLabel = this.anyRelationshipType + 1L;
        this.labelsCounts = cacheFactory.newLongArray(this.sideSize() * 2L, 0L);
        this.wildcardCounts = cacheFactory.newLongArray(this.anyRelationshipType + 1L, 0L);
    }

    static long calculateMemoryUsage(int highLabelId, int highRelationshipTypeId) {
        long labels2 = highLabelId + 1;
        long types2 = highRelationshipTypeId + 1;
        long labelsCountsUsage = labels2 * types2 * 2L * 8L;
        long wildcardCountsUsage = types2 * 8L;
        return labelsCountsUsage + wildcardCountsUsage;
    }

    @Override
    public boolean process(RelationshipRecord record) {
        int type = record.getType();
        this.increment(this.wildcardCounts, this.anyRelationshipType);
        this.increment(this.wildcardCounts, type);
        for (int startNodeLabelId : this.startScratch = this.nodeLabelCache.get(this.client, record.getFirstNode(), this.startScratch)) {
            if (startNodeLabelId == -1) break;
            this.increment(this.labelsCounts, startNodeLabelId, this.anyRelationshipType, 0L);
            this.increment(this.labelsCounts, startNodeLabelId, type, 0L);
        }
        this.endScratch = this.nodeLabelCache.get(this.client, record.getSecondNode(), this.endScratch);
        for (int endNodeLabelId : this.endScratch) {
            if (endNodeLabelId == -1) break;
            this.increment(this.labelsCounts, endNodeLabelId, this.anyRelationshipType, 1L);
            this.increment(this.labelsCounts, endNodeLabelId, type, 1L);
        }
        return false;
    }

    @Override
    public void done() {
        int wildcardType = 0;
        while ((long)wildcardType <= this.anyRelationshipType) {
            int type = (long)wildcardType == this.anyRelationshipType ? -1 : wildcardType;
            long count2 = this.wildcardCounts.get(wildcardType);
            this.countsUpdater.incrementRelationshipCount(-1L, type, -1L, count2);
            ++wildcardType;
        }
        int labelId = 0;
        while ((long)labelId < this.anyLabel) {
            int typeId = 0;
            while ((long)typeId <= this.anyRelationshipType) {
                long startCount = this.labelsCounts.get(this.arrayIndex(labelId, typeId, 0L));
                long endCount = this.labelsCounts.get(this.arrayIndex(labelId, typeId, 1L));
                int type = (long)typeId == this.anyRelationshipType ? -1 : typeId;
                this.countsUpdater.incrementRelationshipCount(labelId, type, -1L, startCount);
                this.countsUpdater.incrementRelationshipCount(-1L, type, labelId, endCount);
                ++typeId;
            }
            ++labelId;
        }
    }

    @Override
    public void close() {
        this.labelsCounts.close();
        this.wildcardCounts.close();
    }

    public void addCountsFrom(RelationshipCountsProcessor from2) {
        this.mergeCounts(this.labelsCounts, from2.labelsCounts);
        this.mergeCounts(this.wildcardCounts, from2.wildcardCounts);
    }

    private void mergeCounts(LongArray destination, LongArray part) {
        long length2 = destination.length();
        for (long i = 0L; i < length2; ++i) {
            destination.set(i, destination.get(i) + part.get(i));
        }
    }

    private long arrayIndex(long labelId, long relationshipTypeId, long side) {
        return side * this.sideSize() + (labelId * this.itemsPerLabel + relationshipTypeId);
    }

    private long sideSize() {
        return this.itemsPerType * this.itemsPerLabel;
    }

    private void increment(LongArray counts, long labelId, long relationshipTypeId, long side) {
        long index = this.arrayIndex(labelId, relationshipTypeId, side);
        this.increment(counts, index);
    }

    private void increment(LongArray counts, long index) {
        counts.set(index, counts.get(index) + 1L);
    }
}

