/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;

public class ReadAheadLogChannel
extends ReadAheadChannel<LogVersionedStoreChannel>
implements ReadableLogChannel {
    private final LogVersionBridge bridge;

    public ReadAheadLogChannel(LogVersionedStoreChannel startingChannel) {
        this(startingChannel, LogVersionBridge.NO_MORE_CHANNELS, DEFAULT_READ_AHEAD_SIZE);
    }

    public ReadAheadLogChannel(LogVersionedStoreChannel startingChannel, LogVersionBridge bridge2) {
        this(startingChannel, bridge2, DEFAULT_READ_AHEAD_SIZE);
    }

    public ReadAheadLogChannel(LogVersionedStoreChannel startingChannel, LogVersionBridge bridge2, int readAheadSize) {
        super(startingChannel, readAheadSize);
        this.bridge = bridge2;
    }

    @Override
    public long getVersion() {
        return ((LogVersionedStoreChannel)this.channel).getVersion();
    }

    @Override
    public byte getLogFormatVersion() {
        return ((LogVersionedStoreChannel)this.channel).getLogFormatVersion();
    }

    @Override
    public LogPositionMarker getCurrentPosition(LogPositionMarker positionMarker) throws IOException {
        positionMarker.mark(((LogVersionedStoreChannel)this.channel).getVersion(), this.position());
        return positionMarker;
    }

    @Override
    protected LogVersionedStoreChannel next(LogVersionedStoreChannel channel) throws IOException {
        return this.bridge.next(channel);
    }
}

