/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.PositionableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosableChannel;
import org.neo4j.storageengine.api.ReadPastEndException;

public class ReadAheadChannel<T extends StoreChannel>
implements ReadableClosableChannel,
PositionableChannel {
    public static final int DEFAULT_READ_AHEAD_SIZE = Math.toIntExact(ByteUnit.kibiBytes((long)4L));
    protected T channel;
    private final ByteBuffer aheadBuffer;
    private final int readAheadSize;

    public ReadAheadChannel(T channel) {
        this(channel, DEFAULT_READ_AHEAD_SIZE);
    }

    public ReadAheadChannel(T channel, int readAheadSize) {
        this(channel, ByteBuffer.allocate(readAheadSize));
    }

    public ReadAheadChannel(T channel, ByteBuffer byteBuffer) {
        this.aheadBuffer = byteBuffer;
        this.aheadBuffer.position(this.aheadBuffer.capacity());
        this.channel = channel;
        this.readAheadSize = byteBuffer.capacity();
    }

    public long position() throws IOException {
        return this.channel.position() - (long)this.aheadBuffer.remaining();
    }

    public byte get() throws IOException {
        this.ensureDataExists(1);
        return this.aheadBuffer.get();
    }

    public short getShort() throws IOException {
        this.ensureDataExists(2);
        return this.aheadBuffer.getShort();
    }

    public int getInt() throws IOException {
        this.ensureDataExists(4);
        return this.aheadBuffer.getInt();
    }

    public long getLong() throws IOException {
        this.ensureDataExists(8);
        return this.aheadBuffer.getLong();
    }

    public float getFloat() throws IOException {
        this.ensureDataExists(4);
        return this.aheadBuffer.getFloat();
    }

    public double getDouble() throws IOException {
        this.ensureDataExists(8);
        return this.aheadBuffer.getDouble();
    }

    public void get(byte[] bytes2, int length2) throws IOException {
        int chunkSize;
        assert (length2 <= bytes2.length);
        for (int bytesGotten = 0; bytesGotten < length2; bytesGotten += chunkSize) {
            chunkSize = Math.min(this.readAheadSize >> 2, length2 - bytesGotten);
            this.ensureDataExists(chunkSize);
            this.aheadBuffer.get(bytes2, bytesGotten, chunkSize);
        }
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    private void ensureDataExists(int requestedNumberOfBytes) throws IOException {
        int remaining = this.aheadBuffer.remaining();
        if (remaining >= requestedNumberOfBytes) {
            return;
        }
        this.aheadBuffer.compact();
        while (this.aheadBuffer.position() < this.aheadBuffer.capacity()) {
            int read = this.channel.read(this.aheadBuffer);
            if (read != -1) continue;
            if (this.aheadBuffer.position() >= requestedNumberOfBytes) break;
            T nextChannel = this.next(this.channel);
            assert (nextChannel != null);
            if (nextChannel == this.channel) {
                this.aheadBuffer.flip();
                throw ReadPastEndException.INSTANCE;
            }
            this.channel = nextChannel;
        }
        this.aheadBuffer.flip();
    }

    protected T next(T channel) throws IOException {
        return channel;
    }

    @Override
    public void setCurrentPosition(long byteOffset) throws IOException {
        long positionRelativeToAheadBuffer = byteOffset - (this.channel.position() - (long)this.aheadBuffer.limit());
        if (positionRelativeToAheadBuffer >= (long)this.aheadBuffer.limit() || positionRelativeToAheadBuffer < 0L) {
            this.aheadBuffer.position(this.aheadBuffer.limit());
            this.channel.position(byteOffset);
        } else {
            this.aheadBuffer.position(Math.toIntExact(positionRelativeToAheadBuffer));
        }
    }
}

