/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.recovery.LogTailScanner;

public class UpgradableDatabase {
    private final StoreVersionCheck storeVersionCheck;
    private final RecordFormats format;
    private final LogTailScanner tailScanner;

    public UpgradableDatabase(StoreVersionCheck storeVersionCheck, RecordFormats format2, LogTailScanner tailScanner) {
        this.storeVersionCheck = storeVersionCheck;
        this.format = format2;
        this.tailScanner = tailScanner;
    }

    public RecordFormats checkUpgradable(DatabaseLayout dbDirectoryLayout) {
        File neostoreFile = dbDirectoryLayout.metadataStore();
        StoreVersionCheck.Result result2 = this.storeVersionCheck.hasVersion(neostoreFile, this.format.storeVersion());
        if (result2.outcome.isSuccessful()) {
            return this.format;
        }
        try {
            RecordFormats fromFormat = RecordFormatSelector.selectForVersion(result2.actualVersion);
            if (FormatFamily.isLowerFamilyFormat(this.format, fromFormat)) {
                throw new StoreUpgrader.UnexpectedUpgradingStoreFormatException();
            }
            if (FormatFamily.isSameFamily(fromFormat, this.format) && fromFormat.generation() > this.format.generation()) {
                result2 = new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.attemptedStoreDowngrade, fromFormat.storeVersion(), neostoreFile.getAbsolutePath());
            } else {
                result2 = this.checkCleanShutDownByCheckPoint();
                if (result2.outcome.isSuccessful()) {
                    return fromFormat;
                }
            }
        }
        catch (IllegalArgumentException e) {
            result2 = new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.unexpectedStoreVersion, result2.actualVersion, result2.storeFilename);
        }
        switch (result2.outcome) {
            case missingStoreFile: {
                throw new StoreUpgrader.UpgradeMissingStoreFilesException(UpgradableDatabase.getPathToStoreFile(dbDirectoryLayout, result2));
            }
            case storeVersionNotFound: {
                throw new StoreUpgrader.UpgradingStoreVersionNotFoundException(UpgradableDatabase.getPathToStoreFile(dbDirectoryLayout, result2));
            }
            case attemptedStoreDowngrade: {
                throw new StoreUpgrader.AttemptedDowngradeException();
            }
            case unexpectedStoreVersion: {
                throw new StoreUpgrader.UnexpectedUpgradingStoreVersionException(result2.actualVersion, this.format.storeVersion());
            }
            case storeNotCleanlyShutDown: {
                throw new StoreUpgrader.DatabaseNotCleanlyShutDownException();
            }
        }
        throw new IllegalArgumentException("Unexpected outcome: " + result2.outcome.name());
    }

    private StoreVersionCheck.Result checkCleanShutDownByCheckPoint() {
        try {
            if (!this.tailScanner.getTailInformation().commitsAfterLastCheckpoint()) {
                return new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.ok, null, null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.storeNotCleanlyShutDown, null, null);
    }

    private static String getPathToStoreFile(DatabaseLayout directoryLayout, StoreVersionCheck.Result result2) {
        return directoryLayout.file(result2.storeFilename).getAbsolutePath();
    }

    boolean hasCurrentVersion(DatabaseLayout dbDirectoryLayout) {
        File neoStore = dbDirectoryLayout.metadataStore();
        StoreVersionCheck.Result result2 = this.storeVersionCheck.hasVersion(neoStore, this.format.storeVersion());
        switch (result2.outcome) {
            case missingStoreFile: 
            case ok: {
                return true;
            }
            case storeVersionNotFound: 
            case attemptedStoreDowngrade: 
            case unexpectedStoreVersion: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown outcome: " + result2.outcome.name());
    }

    public String currentVersion() {
        return this.format.storeVersion();
    }
}

