/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import org.apache.commons.lang3.exception.CloneFailedException;

public abstract class AbstractBaseRecord
implements Cloneable {
    public static final int NO_ID = -1;
    private long id;
    private long secondaryUnitId;
    private boolean requiresSecondaryUnit;
    private boolean inUse;
    private boolean created;
    private boolean useFixedReferences;

    protected AbstractBaseRecord(long id2) {
        this.id = id2;
        this.clear();
    }

    protected AbstractBaseRecord initialize(boolean inUse) {
        this.inUse = inUse;
        this.created = false;
        this.secondaryUnitId = -1L;
        this.requiresSecondaryUnit = false;
        this.useFixedReferences = false;
        return this;
    }

    public void clear() {
        this.inUse = false;
        this.created = false;
        this.secondaryUnitId = -1L;
        this.requiresSecondaryUnit = false;
        this.useFixedReferences = false;
    }

    public long getId() {
        return this.id;
    }

    public int getIntId() {
        return Math.toIntExact(this.id);
    }

    public final void setId(long id2) {
        this.id = id2;
    }

    public void setSecondaryUnitId(long id2) {
        this.secondaryUnitId = id2;
    }

    public boolean hasSecondaryUnitId() {
        return this.secondaryUnitId != -1L;
    }

    public long getSecondaryUnitId() {
        return this.secondaryUnitId;
    }

    public void setRequiresSecondaryUnit(boolean requires) {
        this.requiresSecondaryUnit = requires;
    }

    public boolean requiresSecondaryUnit() {
        return this.requiresSecondaryUnit;
    }

    public final boolean inUse() {
        return this.inUse;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public final void setCreated() {
        this.created = true;
    }

    public final boolean isCreated() {
        return this.created;
    }

    public boolean isUseFixedReferences() {
        return this.useFixedReferences;
    }

    public void setUseFixedReferences(boolean useFixedReferences) {
        this.useFixedReferences = useFixedReferences;
    }

    public int hashCode() {
        return (int)(this.id >>> 32 ^ this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractBaseRecord other2 = (AbstractBaseRecord)obj;
        return this.id == other2.id;
    }

    public AbstractBaseRecord clone() {
        try {
            return (AbstractBaseRecord)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CloneFailedException(e);
        }
    }
}

