/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import java.io.IOException;
import java.util.function.LongSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.id.IdContainer;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;

public class IdGeneratorImpl
implements IdGenerator {
    public static final long INTEGER_MINUS_ONE = 0xFFFFFFFFL;
    private final long max;
    private final IdContainer idContainer;
    private long highId;
    private final IdType idType;

    public IdGeneratorImpl(FileSystemAbstraction fs, File file, int grabSize, long max2, boolean aggressiveReuse, IdType idType, LongSupplier highId) {
        this.max = max2;
        this.idType = idType;
        this.idContainer = new IdContainer(fs, file, grabSize, aggressiveReuse);
        this.highId = this.idContainer.init() ? this.idContainer.getInitialHighId() : highId.getAsLong();
    }

    @Override
    public synchronized long nextId() {
        this.assertStillOpen();
        long nextDefragId = this.idContainer.getReusableId();
        if (nextDefragId != -1L) {
            return nextDefragId;
        }
        if (IdValidator.isReservedId(this.highId)) {
            ++this.highId;
        }
        IdValidator.assertValidId(this.idType, this.highId, this.max);
        return this.highId++;
    }

    @Override
    public synchronized IdRange nextIdBatch(int size2) {
        this.assertStillOpen();
        long[] reusableIds = this.idContainer.getReusableIds(size2);
        int sizeLeftForRange = size2 - reusableIds.length;
        long start = this.highId;
        this.setHighId(start + (long)sizeLeftForRange);
        return new IdRange(reusableIds, start, sizeLeftForRange);
    }

    @Override
    public synchronized void setHighId(long id2) {
        IdValidator.assertIdWithinCapacity(this.idType, id2, this.max);
        this.highId = id2;
    }

    @Override
    public synchronized long getHighId() {
        return this.highId;
    }

    @Override
    public synchronized long getHighestPossibleIdInUse() {
        return this.highId - 1L;
    }

    @Override
    public synchronized void freeId(long id2) {
        this.idContainer.assertStillOpen();
        if (IdValidator.isReservedId(id2)) {
            return;
        }
        if (id2 < 0L || id2 >= this.highId) {
            throw new IllegalArgumentException("Illegal id[" + id2 + "], highId is " + this.highId);
        }
        this.idContainer.freeId(id2);
    }

    @Override
    public synchronized void close() {
        this.idContainer.close(this.highId);
    }

    public static void createGenerator(FileSystemAbstraction fs, File fileName, long highId, boolean throwIfFileExists) {
        IdContainer.createEmptyIdFile(fs, fileName, highId, throwIfFileExists);
    }

    public static long readHighId(FileSystemAbstraction fileSystem, File file) throws IOException {
        return IdContainer.readHighId(fileSystem, file);
    }

    public static long readDefragCount(FileSystemAbstraction fileSystem, File file) throws IOException {
        return IdContainer.readDefragCount(fileSystem, file);
    }

    @Override
    public synchronized long getNumberOfIdsInUse() {
        return this.highId - this.getDefragCount();
    }

    @Override
    public synchronized long getDefragCount() {
        return this.idContainer.getFreeIdCount();
    }

    @Override
    public synchronized void delete() {
        this.idContainer.delete();
    }

    private void assertStillOpen() {
        this.idContainer.assertStillOpen();
    }

    public String toString() {
        return "IdGeneratorImpl " + this.hashCode() + " [max=" + this.max + ", idContainer=" + this.idContainer + "]";
    }
}

