/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts.keys;

import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyType;
import org.neo4j.kernel.impl.util.IdPrettyPrinter;

public final class RelationshipKey
implements CountsKey {
    private final int startLabelId;
    private final int typeId;
    private final int endLabelId;

    RelationshipKey(int startLabelId, int typeId, int endLabelId) {
        this.startLabelId = startLabelId;
        this.typeId = typeId;
        this.endLabelId = endLabelId;
    }

    public int getStartLabelId() {
        return this.startLabelId;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public int getEndLabelId() {
        return this.endLabelId;
    }

    public String toString() {
        return String.format("RelationshipKey[(%s)-%s->(%s)]", IdPrettyPrinter.label(this.startLabelId), IdPrettyPrinter.relationshipType(this.typeId), IdPrettyPrinter.label(this.endLabelId));
    }

    @Override
    public void accept(CountsVisitor visitor, long ignored, long count2) {
        visitor.visitRelationshipCount(this.startLabelId, this.typeId, this.endLabelId, count2);
    }

    @Override
    public CountsKeyType recordType() {
        return CountsKeyType.ENTITY_RELATIONSHIP;
    }

    public int hashCode() {
        int result2 = this.startLabelId;
        result2 = 31 * result2 + this.typeId;
        result2 = 31 * result2 + this.endLabelId;
        result2 = 31 * result2 + this.recordType().hashCode();
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RelationshipKey) {
            RelationshipKey that = (RelationshipKey)o;
            return this.endLabelId == that.endLabelId && this.startLabelId == that.startLabelId && this.typeId == that.typeId;
        }
        return false;
    }

    @Override
    public int compareTo(CountsKey other2) {
        if (other2 instanceof RelationshipKey) {
            RelationshipKey that = (RelationshipKey)other2;
            if (this.typeId != that.typeId) {
                return Integer.compare(this.typeId, that.typeId);
            }
            if (this.startLabelId != that.startLabelId) {
                return Integer.compare(this.startLabelId, that.startLabelId);
            }
            return Integer.compare(this.endLabelId, that.endLabelId);
        }
        return this.recordType().compareTo(other2.recordType());
    }
}

