/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.proc.ByteArrayConverter;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.procedure.Name;

public class MethodSignatureCompiler {
    private final TypeMappers typeMappers;

    public MethodSignatureCompiler(TypeMappers typeMappers) {
        this.typeMappers = typeMappers;
    }

    public List<Neo4jTypes.AnyType> inputTypesFor(Method method) throws ProcedureException {
        Type[] types2 = method.getGenericParameterTypes();
        ArrayList<Neo4jTypes.AnyType> neoTypes = new ArrayList<Neo4jTypes.AnyType>(types2.length);
        for (Type type : types2) {
            neoTypes.add(this.typeMappers.toNeo4jType(type));
        }
        return neoTypes;
    }

    public List<FieldSignature> signatureFor(Method method) throws ProcedureException {
        Parameter[] params2 = method.getParameters();
        Type[] types2 = method.getGenericParameterTypes();
        ArrayList<FieldSignature> signature = new ArrayList<FieldSignature>(params2.length);
        boolean seenDefault = false;
        for (int i = 0; i < params2.length; ++i) {
            Parameter param2 = params2[i];
            Type type = types2[i];
            if (!param2.isAnnotationPresent(Name.class)) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Argument at position %d in method `%s` is missing an `@%s` annotation.%nPlease add the annotation, recompile the class and try again.", new Object[]{i, method.getName(), Name.class.getSimpleName()});
            }
            Name parameter = param2.getAnnotation(Name.class);
            String name = parameter.value();
            if (name.trim().length() == 0) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Argument at position %d in method `%s` is annotated with a name,%nbut the name is empty, please provide a non-empty name for the argument.", new Object[]{i, method.getName()});
            }
            try {
                TypeMappers.DefaultValueConverter valueConverter = this.typeMappers.converterFor(type);
                Optional<DefaultParameterValue> defaultValue = valueConverter.defaultValue(parameter);
                if (seenDefault && !defaultValue.isPresent()) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Non-default argument at position %d with name %s in method %s follows default argument. Add a default value or rearrange arguments so that the non-default values comes first.", new Object[]{i, parameter.value(), method.getName()});
                }
                seenDefault = defaultValue.isPresent();
                if (type == byte[].class) {
                    ByteArrayConverter mapper = new ByteArrayConverter();
                    signature.add(defaultValue.map(neo4jValue -> FieldSignature.inputField((String)name, (Neo4jTypes.AnyType)valueConverter.type(), (DefaultParameterValue)neo4jValue, (FieldSignature.InputMapper)mapper)).orElseGet(() -> FieldSignature.inputField((String)name, (Neo4jTypes.AnyType)valueConverter.type(), (FieldSignature.InputMapper)mapper)));
                    continue;
                }
                signature.add(defaultValue.map(neo4jValue -> FieldSignature.inputField((String)name, (Neo4jTypes.AnyType)valueConverter.type(), (DefaultParameterValue)neo4jValue)).orElseGet(() -> FieldSignature.inputField((String)name, (Neo4jTypes.AnyType)valueConverter.type())));
                continue;
            }
            catch (ProcedureException e) {
                throw new ProcedureException(e.status(), "Argument `%s` at position %d in `%s` with%ntype `%s` cannot be converted to a Neo4j type: %s", new Object[]{name, i, method.getName(), param2.getType().getSimpleName(), e.getMessage()});
            }
        }
        return signature;
    }
}

